/*
 * Decompiled with CFR 0.152.
 */
package io.druid.math.expr;

import io.druid.math.expr.Expr;
import io.druid.math.expr.ExprEval;
import io.druid.math.expr.Function;
import java.util.List;
import javax.annotation.Nonnull;

class FunctionExpr
implements Expr {
    final Function function;
    final String name;
    final List<Expr> args;

    public FunctionExpr(Function function, String name, List<Expr> args) {
        this.function = function;
        this.name = name;
        this.args = args;
    }

    public String toString() {
        return "(" + this.name + " " + this.args + ")";
    }

    @Override
    @Nonnull
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return this.function.apply(this.args, bindings);
    }

    @Override
    public void visit(Expr.Visitor visitor) {
        for (Expr child : this.args) {
            child.visit(visitor);
        }
        visitor.visit(this);
    }
}

