/*
 * Decompiled with CFR 0.152.
 */
package io.druid.math.expr;

import com.google.common.base.Preconditions;
import io.druid.math.expr.ConstantExpr;
import io.druid.math.expr.Expr;
import io.druid.math.expr.ExprEval;
import javax.annotation.Nonnull;

class LongExpr
extends ConstantExpr {
    private final Long value;

    public LongExpr(Long value) {
        this.value = (Long)Preconditions.checkNotNull((Object)value, (Object)"value");
    }

    @Override
    @Nonnull
    public Object getLiteralValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    @Nonnull
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return ExprEval.ofLong(this.value);
    }
}

