/*
 * Decompiled with CFR 0.152.
 */
package io.druid.math.expr;

import io.druid.math.expr.Expr;
import io.druid.math.expr.ExprEval;
import io.druid.math.expr.ExprType;
import io.druid.math.expr.UnaryExpr;
import javax.annotation.Nonnull;

class UnaryNotExpr
extends UnaryExpr {
    UnaryNotExpr(Expr expr) {
        super(expr);
    }

    @Override
    @Nonnull
    public ExprEval eval(Expr.ObjectBinding bindings) {
        ExprEval ret = this.expr.eval(bindings);
        ExprType retType = ret.type() == ExprType.DOUBLE ? ExprType.DOUBLE : ExprType.LONG;
        return ExprEval.of(!ret.asBoolean(), retType);
    }

    public String toString() {
        return "!" + this.expr.toString();
    }
}

