/*
 * Decompiled with CFR 0.152.
 */
package io.druid.timeline.partition;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import io.druid.timeline.partition.PartitionChunk;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;

public class PartitionHolder<T>
implements Iterable<PartitionChunk<T>> {
    private final TreeSet<PartitionChunk<T>> holderSet = Sets.newTreeSet();

    public PartitionHolder(PartitionChunk<T> initialChunk) {
        this.add(initialChunk);
    }

    public PartitionHolder(List<PartitionChunk<T>> initialChunks) {
        for (PartitionChunk<T> chunk : initialChunks) {
            this.add(chunk);
        }
    }

    public PartitionHolder(PartitionHolder partitionHolder) {
        this.holderSet.addAll(partitionHolder.holderSet);
    }

    public void add(PartitionChunk<T> chunk) {
        this.holderSet.add(chunk);
    }

    public PartitionChunk<T> remove(PartitionChunk<T> chunk) {
        PartitionChunk element;
        NavigableSet<PartitionChunk<T>> tailSet;
        if (!this.holderSet.isEmpty() && !(tailSet = this.holderSet.tailSet(chunk, true)).isEmpty() && chunk.equals((Object)(element = (PartitionChunk)tailSet.first()))) {
            this.holderSet.remove(element);
            return element;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.holderSet.isEmpty();
    }

    public boolean isComplete() {
        if (this.holderSet.isEmpty()) {
            return false;
        }
        Iterator<PartitionChunk<T>> iter = this.holderSet.iterator();
        PartitionChunk<T> curr = iter.next();
        boolean endSeen = curr.isEnd();
        if (!curr.isStart()) {
            return false;
        }
        while (iter.hasNext()) {
            PartitionChunk<T> next = iter.next();
            if (!curr.abuts(next)) {
                return false;
            }
            if (next.isEnd()) {
                endSeen = true;
            }
            curr = next;
        }
        return endSeen;
    }

    public PartitionChunk<T> getChunk(int partitionNum) {
        UnmodifiableIterator retVal = Iterators.filter(this.holderSet.iterator(), input -> input.getChunkNumber() == partitionNum);
        return retVal.hasNext() ? (PartitionChunk)retVal.next() : null;
    }

    @Override
    public Iterator<PartitionChunk<T>> iterator() {
        return this.holderSet.iterator();
    }

    public Iterable<T> payloads() {
        return Iterables.transform((Iterable)this, PartitionChunk::getObject);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionHolder that = (PartitionHolder)o;
        return this.holderSet.equals(that.holderSet);
    }

    public int hashCode() {
        return this.holderSet.hashCode();
    }

    public String toString() {
        return "PartitionHolder{holderSet=" + this.holderSet + '}';
    }
}

