/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import io.druid.client.DruidServer;
import io.druid.client.ServerInventoryView;
import io.druid.client.ServerView;
import io.druid.curator.inventory.CuratorInventoryManager;
import io.druid.curator.inventory.CuratorInventoryManagerStrategy;
import io.druid.curator.inventory.InventoryManagerConfig;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.concurrent.Execs;
import io.druid.java.util.common.lifecycle.LifecycleStart;
import io.druid.java.util.common.lifecycle.LifecycleStop;
import io.druid.java.util.emitter.EmittingLogger;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.utils.ZKPaths;

public abstract class AbstractCuratorServerInventoryView<InventoryType>
implements ServerInventoryView {
    private final EmittingLogger log;
    private final CuratorFramework curator;
    private final CuratorInventoryManager<DruidServer, InventoryType> inventoryManager;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ConcurrentMap<ServerView.ServerRemovedCallback, Executor> serverRemovedCallbacks = new ConcurrentHashMap<ServerView.ServerRemovedCallback, Executor>();
    private final ConcurrentMap<ServerView.SegmentCallback, Executor> segmentCallbacks = new ConcurrentHashMap<ServerView.SegmentCallback, Executor>();

    public AbstractCuratorServerInventoryView(final EmittingLogger log, final String announcementsPath, final String inventoryPath, CuratorFramework curator, final ObjectMapper jsonMapper, final TypeReference<InventoryType> typeReference) {
        this.log = log;
        this.curator = curator;
        this.inventoryManager = new CuratorInventoryManager(curator, new InventoryManagerConfig(){

            @Override
            public String getContainerPath() {
                return announcementsPath;
            }

            @Override
            public String getInventoryPath() {
                return inventoryPath;
            }
        }, Execs.singleThreaded((String)"ServerInventoryView-%s"), new CuratorInventoryManagerStrategy<DruidServer, InventoryType>(){

            @Override
            public DruidServer deserializeContainer(byte[] bytes) {
                try {
                    return (DruidServer)jsonMapper.readValue(bytes, DruidServer.class);
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }

            @Override
            public InventoryType deserializeInventory(byte[] bytes) {
                try {
                    return jsonMapper.readValue(bytes, typeReference);
                }
                catch (IOException e) {
                    log.error((Throwable)e, "Could not parse json: %s", new Object[]{StringUtils.fromUtf8((byte[])bytes)});
                    throw Throwables.propagate((Throwable)e);
                }
            }

            @Override
            public void newContainer(DruidServer container) {
                log.info("New Server[%s]", new Object[]{container});
            }

            @Override
            public void deadContainer(DruidServer deadContainer) {
                log.info("Server Disappeared[%s]", new Object[]{deadContainer});
                AbstractCuratorServerInventoryView.this.runServerRemovedCallbacks(deadContainer);
            }

            @Override
            public DruidServer updateContainer(DruidServer oldContainer, DruidServer newContainer) {
                return newContainer.addDataSegments(oldContainer);
            }

            @Override
            public DruidServer addInventory(DruidServer container, String inventoryKey, InventoryType inventory) {
                return AbstractCuratorServerInventoryView.this.addInnerInventory(container, inventoryKey, inventory);
            }

            @Override
            public DruidServer updateInventory(DruidServer container, String inventoryKey, InventoryType inventory) {
                return AbstractCuratorServerInventoryView.this.updateInnerInventory(container, inventoryKey, inventory);
            }

            @Override
            public DruidServer removeInventory(DruidServer container, String inventoryKey) {
                return AbstractCuratorServerInventoryView.this.removeInnerInventory(container, inventoryKey);
            }

            @Override
            public void inventoryInitialized() {
                log.info("Inventory Initialized", new Object[0]);
                AbstractCuratorServerInventoryView.this.runSegmentCallbacks(new Function<ServerView.SegmentCallback, ServerView.CallbackAction>(){

                    public ServerView.CallbackAction apply(ServerView.SegmentCallback input) {
                        return input.segmentViewInitialized();
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() throws Exception {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (!this.started.get()) {
                this.inventoryManager.start();
                this.started.set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() throws IOException {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (this.started.getAndSet(false)) {
                this.inventoryManager.stop();
            }
        }
    }

    @Override
    public boolean isStarted() {
        return this.started.get();
    }

    @Override
    public DruidServer getInventoryValue(String containerKey) {
        return this.inventoryManager.getInventoryValue(containerKey);
    }

    @Override
    public Collection<DruidServer> getInventory() {
        return this.inventoryManager.getInventory();
    }

    @Override
    public void registerServerRemovedCallback(Executor exec, ServerView.ServerRemovedCallback callback) {
        this.serverRemovedCallbacks.put(callback, exec);
    }

    @Override
    public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback) {
        this.segmentCallbacks.put(callback, exec);
    }

    public InventoryManagerConfig getInventoryManagerConfig() {
        return this.inventoryManager.getConfig();
    }

    protected void runSegmentCallbacks(final Function<ServerView.SegmentCallback, ServerView.CallbackAction> fn) {
        for (final Map.Entry entry : this.segmentCallbacks.entrySet()) {
            ((Executor)entry.getValue()).execute(new Runnable(){

                @Override
                public void run() {
                    if (ServerView.CallbackAction.UNREGISTER == fn.apply(entry.getKey())) {
                        AbstractCuratorServerInventoryView.this.segmentCallbackRemoved((ServerView.SegmentCallback)entry.getKey());
                        AbstractCuratorServerInventoryView.this.segmentCallbacks.remove(entry.getKey());
                    }
                }
            });
        }
    }

    private void runServerRemovedCallbacks(final DruidServer server) {
        for (final Map.Entry entry : this.serverRemovedCallbacks.entrySet()) {
            ((Executor)entry.getValue()).execute(new Runnable(){

                @Override
                public void run() {
                    if (ServerView.CallbackAction.UNREGISTER == ((ServerView.ServerRemovedCallback)entry.getKey()).serverRemoved(server)) {
                        AbstractCuratorServerInventoryView.this.serverRemovedCallbacks.remove(entry.getKey());
                    }
                }
            });
        }
    }

    protected void addSingleInventory(final DruidServer container, final DataSegment inventory) {
        this.log.debug("Server[%s] added segment[%s]", new Object[]{container.getName(), inventory.getIdentifier()});
        if (container.getSegment(inventory.getIdentifier()) != null) {
            this.log.warn("Not adding or running callbacks for existing segment[%s] on server[%s]", new Object[]{inventory.getIdentifier(), container.getName()});
            return;
        }
        container.addDataSegment(inventory);
        this.runSegmentCallbacks(new Function<ServerView.SegmentCallback, ServerView.CallbackAction>(){

            public ServerView.CallbackAction apply(ServerView.SegmentCallback input) {
                return input.segmentAdded(container.getMetadata(), inventory);
            }
        });
    }

    protected void removeSingleInventory(final DruidServer container, String inventoryKey) {
        this.log.debug("Server[%s] removed segment[%s]", new Object[]{container.getName(), inventoryKey});
        final DataSegment segment = container.getSegment(inventoryKey);
        if (segment == null) {
            this.log.warn("Not running cleanup or callbacks for non-existing segment[%s] on server[%s]", new Object[]{inventoryKey, container.getName()});
            return;
        }
        container.removeDataSegment(inventoryKey);
        this.runSegmentCallbacks(new Function<ServerView.SegmentCallback, ServerView.CallbackAction>(){

            public ServerView.CallbackAction apply(ServerView.SegmentCallback input) {
                return input.segmentRemoved(container.getMetadata(), segment);
            }
        });
    }

    @Override
    public boolean isSegmentLoadedByServer(String serverKey, DataSegment segment) {
        try {
            String toServedSegPath = ZKPaths.makePath((String)ZKPaths.makePath((String)this.getInventoryManagerConfig().getInventoryPath(), (String)serverKey), (String)segment.getIdentifier());
            return this.curator.checkExists().forPath(toServedSegPath) != null;
        }
        catch (Exception ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    protected abstract DruidServer addInnerInventory(DruidServer var1, String var2, InventoryType var3);

    protected abstract DruidServer updateInnerInventory(DruidServer var1, String var2, InventoryType var3);

    protected abstract DruidServer removeInnerInventory(DruidServer var1, String var2);

    protected abstract void segmentCallbackRemoved(ServerView.SegmentCallback var1);
}

