/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.druid.client.AbstractCuratorServerInventoryView;
import io.druid.client.DruidServer;
import io.druid.client.FilteredServerInventoryView;
import io.druid.client.ServerView;
import io.druid.client.SingleServerInventoryView;
import io.druid.guice.ManageLifecycle;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.Pair;
import io.druid.java.util.emitter.EmittingLogger;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.server.initialization.ZkPathsConfig;
import io.druid.timeline.DataSegment;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.apache.curator.framework.CuratorFramework;

@Deprecated
@ManageLifecycle
public class BatchServerInventoryView
extends AbstractCuratorServerInventoryView<Set<DataSegment>>
implements FilteredServerInventoryView {
    private static final EmittingLogger log = new EmittingLogger(BatchServerInventoryView.class);
    private final ConcurrentMap<String, Set<DataSegment>> zNodes = new ConcurrentHashMap<String, Set<DataSegment>>();
    private final ConcurrentMap<ServerView.SegmentCallback, Predicate<Pair<DruidServerMetadata, DataSegment>>> segmentPredicates = new ConcurrentHashMap<ServerView.SegmentCallback, Predicate<Pair<DruidServerMetadata, DataSegment>>>();
    private final Predicate<Pair<DruidServerMetadata, DataSegment>> defaultFilter;

    @Inject
    public BatchServerInventoryView(ZkPathsConfig zkPaths, CuratorFramework curator, ObjectMapper jsonMapper, Predicate<Pair<DruidServerMetadata, DataSegment>> defaultFilter) {
        super(log, zkPaths.getAnnouncementsPath(), zkPaths.getLiveSegmentsPath(), curator, jsonMapper, new TypeReference<Set<DataSegment>>(){});
        this.defaultFilter = (Predicate)Preconditions.checkNotNull(defaultFilter);
    }

    @Override
    protected DruidServer addInnerInventory(DruidServer container, String inventoryKey, Set<DataSegment> inventory) {
        Set<DataSegment> filteredInventory = this.filterInventory(container, inventory);
        this.zNodes.put(inventoryKey, filteredInventory);
        for (DataSegment segment : filteredInventory) {
            this.addSingleInventory(container, segment);
        }
        return container;
    }

    private Set<DataSegment> filterInventory(final DruidServer container, Set<DataSegment> inventory) {
        Predicate predicate = Predicates.or(this.defaultFilter, (Predicate)Predicates.or(this.segmentPredicates.values()));
        HashSet filteredInventory = Sets.newHashSet((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)Iterables.transform(inventory, (Function)new Function<DataSegment, Pair<DruidServerMetadata, DataSegment>>(){

            public Pair<DruidServerMetadata, DataSegment> apply(DataSegment input) {
                return Pair.of((Object)container.getMetadata(), (Object)input);
            }
        }), (Predicate)predicate), (Function)new Function<Pair<DruidServerMetadata, DataSegment>, DataSegment>(){

            public DataSegment apply(Pair<DruidServerMetadata, DataSegment> input) {
                return (DataSegment)input.rhs;
            }
        }));
        return filteredInventory;
    }

    @Override
    protected DruidServer updateInnerInventory(DruidServer container, String inventoryKey, Set<DataSegment> inventory) {
        Set<DataSegment> filteredInventory = this.filterInventory(container, inventory);
        Set existing = (Set)this.zNodes.get(inventoryKey);
        if (existing == null) {
            throw new ISE("Trying to update an inventoryKey[%s] that didn't exist?!", new Object[]{inventoryKey});
        }
        for (DataSegment segment : Sets.difference(filteredInventory, (Set)existing)) {
            this.addSingleInventory(container, segment);
        }
        for (DataSegment segment : Sets.difference((Set)existing, filteredInventory)) {
            this.removeSingleInventory(container, segment.getIdentifier());
        }
        this.zNodes.put(inventoryKey, filteredInventory);
        return container;
    }

    @Override
    protected DruidServer removeInnerInventory(DruidServer container, String inventoryKey) {
        log.debug("Server[%s] removed container[%s]", new Object[]{container.getName(), inventoryKey});
        Set segments = (Set)this.zNodes.remove(inventoryKey);
        if (segments == null) {
            log.warn("Told to remove container[%s], which didn't exist", new Object[]{inventoryKey});
            return container;
        }
        for (DataSegment segment : segments) {
            this.removeSingleInventory(container, segment.getIdentifier());
        }
        return container;
    }

    @Override
    public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback, Predicate<Pair<DruidServerMetadata, DataSegment>> filter) {
        SingleServerInventoryView.FilteringSegmentCallback filteringCallback = new SingleServerInventoryView.FilteringSegmentCallback(callback, filter);
        this.segmentPredicates.put(filteringCallback, filter);
        this.registerSegmentCallback(exec, filteringCallback);
    }

    @Override
    protected void segmentCallbackRemoved(ServerView.SegmentCallback callback) {
        this.segmentPredicates.remove(callback);
    }
}

