/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import io.druid.client.DruidServer;
import io.druid.client.InventoryView;
import io.druid.client.SegmentLoadInfo;
import io.druid.client.ServerInventoryView;
import io.druid.client.ServerView;
import io.druid.java.util.common.concurrent.Execs;
import io.druid.java.util.common.logger.Logger;
import io.druid.query.DataSource;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.timeline.DataSegment;
import io.druid.timeline.VersionedIntervalTimeline;
import io.druid.timeline.partition.PartitionChunk;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class CoordinatorServerView
implements InventoryView {
    private static final Logger log = new Logger(CoordinatorServerView.class);
    private final Object lock = new Object();
    private final Map<String, SegmentLoadInfo> segmentLoadInfos;
    private final Map<String, VersionedIntervalTimeline<String, SegmentLoadInfo>> timelines;
    private final ServerInventoryView baseView;
    private volatile boolean initialized = false;

    @Inject
    public CoordinatorServerView(ServerInventoryView baseView) {
        this.baseView = baseView;
        this.segmentLoadInfos = Maps.newHashMap();
        this.timelines = Maps.newHashMap();
        ExecutorService exec = Execs.singleThreaded((String)"CoordinatorServerView-%s");
        baseView.registerSegmentCallback(exec, new ServerView.SegmentCallback(){

            @Override
            public ServerView.CallbackAction segmentAdded(DruidServerMetadata server, DataSegment segment) {
                CoordinatorServerView.this.serverAddedSegment(server, segment);
                return ServerView.CallbackAction.CONTINUE;
            }

            @Override
            public ServerView.CallbackAction segmentRemoved(DruidServerMetadata server, DataSegment segment) {
                CoordinatorServerView.this.serverRemovedSegment(server, segment);
                return ServerView.CallbackAction.CONTINUE;
            }

            @Override
            public ServerView.CallbackAction segmentViewInitialized() {
                CoordinatorServerView.this.initialized = true;
                return ServerView.CallbackAction.CONTINUE;
            }
        });
        baseView.registerServerRemovedCallback(exec, new ServerView.ServerRemovedCallback(){

            @Override
            public ServerView.CallbackAction serverRemoved(DruidServer server) {
                CoordinatorServerView.this.removeServer(server);
                return ServerView.CallbackAction.CONTINUE;
            }
        });
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.timelines.clear();
            this.segmentLoadInfos.clear();
        }
    }

    private void removeServer(DruidServer server) {
        for (DataSegment segment : server.getSegments().values()) {
            this.serverRemovedSegment(server.getMetadata(), segment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverAddedSegment(DruidServerMetadata server, DataSegment segment) {
        String segmentId = segment.getIdentifier();
        Object object = this.lock;
        synchronized (object) {
            log.debug("Adding segment[%s] for server[%s]", new Object[]{segment, server});
            SegmentLoadInfo segmentLoadInfo = this.segmentLoadInfos.get(segmentId);
            if (segmentLoadInfo == null) {
                segmentLoadInfo = new SegmentLoadInfo(segment);
                VersionedIntervalTimeline timeline = this.timelines.get(segment.getDataSource());
                if (timeline == null) {
                    timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural());
                    this.timelines.put(segment.getDataSource(), (VersionedIntervalTimeline<String, SegmentLoadInfo>)timeline);
                }
                timeline.add(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)segmentLoadInfo));
                this.segmentLoadInfos.put(segmentId, segmentLoadInfo);
            }
            segmentLoadInfo.addServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverRemovedSegment(DruidServerMetadata server, DataSegment segment) {
        String segmentId = segment.getIdentifier();
        Object object = this.lock;
        synchronized (object) {
            log.debug("Removing segment[%s] from server[%s].", new Object[]{segmentId, server});
            SegmentLoadInfo segmentLoadInfo = this.segmentLoadInfos.get(segmentId);
            if (segmentLoadInfo == null) {
                log.warn("Told to remove non-existant segment[%s]", new Object[]{segmentId});
                return;
            }
            segmentLoadInfo.removeServer(server);
            if (segmentLoadInfo.isEmpty()) {
                VersionedIntervalTimeline<String, SegmentLoadInfo> timeline = this.timelines.get(segment.getDataSource());
                this.segmentLoadInfos.remove(segmentId);
                PartitionChunk removedPartition = timeline.remove(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)new SegmentLoadInfo(segment)));
                if (removedPartition == null) {
                    log.warn("Asked to remove timeline entry[interval: %s, version: %s] that doesn't exist", new Object[]{segment.getInterval(), segment.getVersion()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedIntervalTimeline<String, SegmentLoadInfo> getTimeline(DataSource dataSource) {
        String table = (String)Iterables.getOnlyElement((Iterable)dataSource.getNames());
        Object object = this.lock;
        synchronized (object) {
            return this.timelines.get(table);
        }
    }

    @Override
    public DruidServer getInventoryValue(String string) {
        return this.baseView.getInventoryValue(string);
    }

    @Override
    public Collection<DruidServer> getInventory() {
        return this.baseView.getInventory();
    }

    @Override
    public boolean isStarted() {
        return this.baseView.isStarted();
    }

    @Override
    public boolean isSegmentLoadedByServer(String serverKey, DataSegment segment) {
        return this.baseView.isSegmentLoadedByServer(serverKey, segment);
    }
}

