/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.druid.timeline.DataSegment;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class ImmutableDruidDataSource {
    private final String name;
    private final ImmutableMap<String, String> properties;
    private final ImmutableMap<String, DataSegment> idToSegments;

    public ImmutableDruidDataSource(String name, ImmutableMap<String, String> properties, ImmutableMap<String, DataSegment> idToSegments) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.properties = properties;
        this.idToSegments = idToSegments;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isEmpty() {
        return this.idToSegments.isEmpty();
    }

    public Collection<DataSegment> getSegments() {
        return this.idToSegments.values();
    }

    public DataSegment getSegment(String segmentIdentifier) {
        return (DataSegment)this.idToSegments.get((Object)segmentIdentifier);
    }

    public String toString() {
        return "ImmutableDruidDataSource{name='" + this.name + "', # of segments='" + this.idToSegments.size() + "', properties='" + this.properties + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        ImmutableDruidDataSource that = (ImmutableDruidDataSource)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.properties.equals(that.properties)) {
            return false;
        }
        return this.idToSegments.equals(that.idToSegments);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.properties, this.idToSegments);
    }
}

