/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.druid.client.ImmutableDruidDataSource;
import io.druid.java.util.common.StringUtils;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.server.coordination.ServerType;
import io.druid.timeline.DataSegment;
import java.util.Map;

public class ImmutableDruidServer {
    private final DruidServerMetadata metadata;
    private final long currSize;
    private final ImmutableMap<String, ImmutableDruidDataSource> dataSources;
    private final ImmutableMap<String, DataSegment> segments;

    public ImmutableDruidServer(DruidServerMetadata metadata, long currSize, ImmutableMap<String, ImmutableDruidDataSource> dataSources, ImmutableMap<String, DataSegment> segments) {
        this.metadata = (DruidServerMetadata)Preconditions.checkNotNull((Object)metadata);
        this.currSize = currSize;
        this.segments = segments;
        this.dataSources = dataSources;
    }

    public String getName() {
        return this.metadata.getName();
    }

    public DruidServerMetadata getMetadata() {
        return this.metadata;
    }

    public String getHost() {
        return this.metadata.getHost();
    }

    public long getCurrSize() {
        return this.currSize;
    }

    public long getMaxSize() {
        return this.metadata.getMaxSize();
    }

    public ServerType getType() {
        return this.metadata.getType();
    }

    public String getTier() {
        return this.metadata.getTier();
    }

    public int getPriority() {
        return this.metadata.getPriority();
    }

    public DataSegment getSegment(String segmentName) {
        return (DataSegment)this.segments.get((Object)segmentName);
    }

    public Iterable<ImmutableDruidDataSource> getDataSources() {
        return this.dataSources.values();
    }

    public ImmutableDruidDataSource getDataSource(String name) {
        return (ImmutableDruidDataSource)this.dataSources.get((Object)name);
    }

    public Map<String, DataSegment> getSegments() {
        return this.segments;
    }

    public String getURL() {
        if (this.metadata.getHostAndTlsPort() != null) {
            return StringUtils.nonStrictFormat((String)"https://%s", (Object[])new Object[]{this.metadata.getHostAndTlsPort()});
        }
        return StringUtils.nonStrictFormat((String)"http://%s", (Object[])new Object[]{this.metadata.getHostAndPort()});
    }

    public String toString() {
        return "ImmutableDruidServer{meta='" + this.metadata + "', size='" + this.currSize + "', sources='" + this.dataSources + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableDruidServer that = (ImmutableDruidServer)o;
        return !this.metadata.equals(that.metadata);
    }

    public int hashCode() {
        return this.metadata.hashCode();
    }
}

