/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client.cache;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.query.Query;
import java.util.Arrays;
import java.util.List;
import javax.validation.constraints.Min;

public class CacheConfig {
    public static final String USE_CACHE = "useCache";
    public static final String POPULATE_CACHE = "populateCache";
    @JsonProperty
    private boolean useCache = false;
    @JsonProperty
    private boolean populateCache = false;
    @JsonProperty
    @Min(value=0L)
    private int numBackgroundThreads = 0;
    @JsonProperty
    @Min(value=0L)
    private int cacheBulkMergeLimit = Integer.MAX_VALUE;
    @JsonProperty
    private List<String> unCacheable = Arrays.asList("groupBy", "select");

    public boolean isPopulateCache() {
        return this.populateCache;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public int getNumBackgroundThreads() {
        return this.numBackgroundThreads;
    }

    public int getCacheBulkMergeLimit() {
        return this.cacheBulkMergeLimit;
    }

    public boolean isQueryCacheable(Query query) {
        return this.isQueryCacheable(query.getType());
    }

    public boolean isQueryCacheable(String queryType) {
        return !this.unCacheable.contains(queryType);
    }
}

