/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client.selector;

import com.google.common.collect.Iterables;
import io.druid.client.selector.QueryableDruidServer;
import io.druid.client.selector.ServerSelectorStrategy;
import io.druid.client.selector.TierSelectorStrategy;
import io.druid.timeline.DataSegment;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class AbstractTierSelectorStrategy
implements TierSelectorStrategy {
    private final ServerSelectorStrategy serverSelectorStrategy;

    public AbstractTierSelectorStrategy(ServerSelectorStrategy serverSelectorStrategy) {
        this.serverSelectorStrategy = serverSelectorStrategy;
    }

    @Override
    @Nullable
    public QueryableDruidServer pick(Int2ObjectRBTreeMap<Set<QueryableDruidServer>> prioritizedServers, DataSegment segment) {
        return (QueryableDruidServer)Iterables.getOnlyElement(this.pick(prioritizedServers, segment, 1), null);
    }

    @Override
    public List<QueryableDruidServer> pick(Int2ObjectRBTreeMap<Set<QueryableDruidServer>> prioritizedServers, DataSegment segment, int numServersToPick) {
        ArrayList<QueryableDruidServer> result = new ArrayList<QueryableDruidServer>(numServersToPick);
        for (Set priorityServers : prioritizedServers.values()) {
            result.addAll(this.serverSelectorStrategy.pick(priorityServers, segment, numServersToPick - result.size()));
            if (result.size() != numServersToPick) continue;
            break;
        }
        return result;
    }
}

