/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.druid.client.coordinator.Coordinator;
import io.druid.client.coordinator.CoordinatorSelectorConfig;
import io.druid.curator.discovery.ServerDiscoveryFactory;
import io.druid.curator.discovery.ServerDiscoverySelector;
import io.druid.discovery.DruidLeaderClient;
import io.druid.discovery.DruidNodeDiscoveryProvider;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.EscalatedGlobal;
import io.druid.java.util.http.client.HttpClient;

public class CoordinatorDiscoveryModule
implements Module {
    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.selectors.coordinator", CoordinatorSelectorConfig.class);
    }

    @Provides
    @Coordinator
    @ManageLifecycle
    public ServerDiscoverySelector getServiceProvider(CoordinatorSelectorConfig config, ServerDiscoveryFactory serverDiscoveryFactory) {
        return serverDiscoveryFactory.createSelector(config.getServiceName());
    }

    @Provides
    @Coordinator
    @ManageLifecycle
    public DruidLeaderClient getLeaderHttpClient(@EscalatedGlobal HttpClient httpClient, DruidNodeDiscoveryProvider druidNodeDiscoveryProvider, @Coordinator ServerDiscoverySelector serverDiscoverySelector) {
        return new DruidLeaderClient(httpClient, druidNodeDiscoveryProvider, "coordinator", "/druid/coordinator/v1/leader", serverDiscoverySelector);
    }
}

