/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.expression;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.druid.java.util.common.IAE;
import io.druid.math.expr.Expr;
import io.druid.math.expr.ExprEval;
import io.druid.math.expr.ExprMacroTable;
import io.druid.query.lookup.LookupReferencesManager;
import io.druid.query.lookup.RegisteredLookupExtractionFn;
import java.util.List;
import javax.annotation.Nonnull;

public class LookupExprMacro
implements ExprMacroTable.ExprMacro {
    private final LookupReferencesManager lookupReferencesManager;

    @Inject
    public LookupExprMacro(LookupReferencesManager lookupReferencesManager) {
        this.lookupReferencesManager = lookupReferencesManager;
    }

    public String name() {
        return "lookup";
    }

    public Expr apply(List<Expr> args) {
        if (args.size() != 2) {
            throw new IAE("Function[%s] must have 2 arguments", new Object[]{this.name()});
        }
        final Expr arg = args.get(0);
        Expr lookupExpr = args.get(1);
        if (!lookupExpr.isLiteral() || lookupExpr.getLiteralValue() == null) {
            throw new IAE("Function[%s] second argument must be a registered lookup name", new Object[]{this.name()});
        }
        String lookupName = lookupExpr.getLiteralValue().toString();
        final RegisteredLookupExtractionFn extractionFn = new RegisteredLookupExtractionFn(this.lookupReferencesManager, lookupName, false, null, false, null);
        class LookupExpr
        implements Expr {
            LookupExpr() {
            }

            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                return ExprEval.of((String)extractionFn.apply(Strings.emptyToNull((String)arg.eval(bindings).asString())));
            }

            public void visit(Expr.Visitor visitor) {
                arg.visit(visitor);
                visitor.visit((Expr)this);
            }
        }
        return new LookupExpr();
    }
}

