/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.lookup;

import com.google.inject.Inject;
import io.druid.java.util.common.logger.Logger;
import io.druid.query.lookup.LookupExtractor;
import io.druid.query.lookup.LookupExtractorFactoryContainer;
import io.druid.query.lookup.LookupIntrospectHandler;
import io.druid.query.lookup.LookupReferencesManager;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/druid/v1/lookups/introspect")
public class LookupIntrospectionResource {
    private static final Logger LOGGER = new Logger(LookupIntrospectionResource.class);
    private final LookupReferencesManager lookupReferencesManager;

    @Inject
    public LookupIntrospectionResource(@Context LookupReferencesManager lookupReferencesManager) {
        this.lookupReferencesManager = lookupReferencesManager;
    }

    @Path(value="/{lookupId}")
    public Object introspectLookup(@PathParam(value="lookupId") String lookupId) {
        LookupExtractorFactoryContainer container = this.lookupReferencesManager.get(lookupId);
        if (container == null) {
            LOGGER.error("trying to introspect non existing lookup [%s]", new Object[]{lookupId});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        LookupIntrospectHandler introspectHandler = container.getLookupExtractorFactory().getIntrospectHandler();
        if (introspectHandler != null) {
            return introspectHandler;
        }
        LOGGER.warn("Trying to introspect lookup [%s] of type [%s] but implementation doesn't provide resource", new Object[]{lookupId, ((LookupExtractor)container.getLookupExtractorFactory().get()).getClass()});
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

