/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.lookup;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import io.druid.common.utils.ServletResourceUtils;
import io.druid.guice.annotations.Json;
import io.druid.guice.annotations.Smile;
import io.druid.java.util.common.logger.Logger;
import io.druid.query.lookup.LookupExtractorFactory;
import io.druid.query.lookup.LookupExtractorFactoryContainer;
import io.druid.query.lookup.LookupReferencesManager;
import io.druid.query.lookup.LookupsState;
import io.druid.server.http.security.ConfigResourceFilter;
import io.druid.server.listener.resource.AbstractListenerHandler;
import io.druid.server.listener.resource.ListenerResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path(value="/druid/listen/v1/lookups")
@ResourceFilters(value={ConfigResourceFilter.class})
class LookupListeningResource
extends ListenerResource {
    private static final Logger LOG = new Logger(LookupListeningResource.class);
    private static final TypeReference<LookupsState<LookupExtractorFactoryContainer>> LOOKUPS_STATE_TYPE_REFERENCE = new TypeReference<LookupsState<LookupExtractorFactoryContainer>>(){};

    @Inject
    public LookupListeningResource(@Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, final LookupReferencesManager manager) {
        super(jsonMapper, smileMapper, new AbstractListenerHandler<LookupExtractorFactory>((TypeReference)new TypeReference<LookupExtractorFactory>(){}){

            @Override
            public Response handleUpdates(InputStream inputStream, ObjectMapper mapper) {
                LookupsState state;
                try {
                    state = (LookupsState)mapper.readValue(inputStream, LOOKUPS_STATE_TYPE_REFERENCE);
                }
                catch (IOException ex) {
                    LOG.debug((Throwable)ex, "Bad request", new Object[0]);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ServletResourceUtils.sanitizeException((Throwable)ex)).build();
                }
                try {
                    state.getToLoad().forEach(manager::add);
                    state.getToDrop().forEach(manager::remove);
                    return Response.status((Response.Status)Response.Status.ACCEPTED).entity(manager.getAllLookupsState()).build();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e, "Error handling request", new Object[0]);
                    return Response.serverError().entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
                }
            }

            @Override
            public Object post(Map<String, LookupExtractorFactory> lookups) throws Exception {
                HashMap failedUpdates = new HashMap();
                for (String name : lookups.keySet()) {
                    LookupExtractorFactoryContainer factoryContainer = new LookupExtractorFactoryContainer(null, lookups.get(name));
                    manager.add(name, factoryContainer);
                }
                return ImmutableMap.of((Object)"status", (Object)"accepted", (Object)"failedUpdates", failedUpdates);
            }

            @Override
            public Object get(String id) {
                return manager.get(id);
            }

            public LookupsState<LookupExtractorFactoryContainer> getAll() {
                return manager.getAllLookupsState();
            }

            @Override
            public Object delete(String id) {
                manager.remove(id);
                return id;
            }
        });
    }
}

