/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.loading;

import com.google.common.base.Throwables;
import io.druid.data.SearchableVersionedDataFinder;
import io.druid.java.util.common.RetryUtils;
import io.druid.segment.loading.LocalDataSegmentPuller;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class LocalFileTimestampVersionFinder
extends LocalDataSegmentPuller
implements SearchableVersionedDataFinder<URI> {
    public static final String URI_SCHEME = "file";

    private URI mostRecentInDir(Path dir, final Pattern pattern) throws IOException {
        long latestModified = Long.MIN_VALUE;
        URI latest = null;
        for (File file : dir.toFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.exists() && pathname.isFile() && (pattern == null || pattern.matcher(pathname.getName()).matches());
            }
        })) {
            long thisModified = file.lastModified();
            if (thisModified < latestModified) continue;
            latestModified = thisModified;
            latest = file.toURI();
        }
        return latest;
    }

    public URI getLatestVersion(URI uri, final @Nullable Pattern pattern) {
        final File file = new File(uri);
        try {
            return (URI)RetryUtils.retry((Callable)new Callable<URI>(){

                @Override
                public URI call() throws Exception {
                    return LocalFileTimestampVersionFinder.this.mostRecentInDir(file.isDirectory() ? file.toPath() : file.getParentFile().toPath(), pattern);
                }
            }, this.shouldRetryPredicate(), (int)3);
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                return null;
            }
            throw Throwables.propagate((Throwable)e);
        }
    }
}

