/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.loading;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.inject.Inject;
import io.druid.guice.annotations.Json;
import io.druid.java.util.emitter.EmittingLogger;
import io.druid.segment.IndexIO;
import io.druid.segment.Segment;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.loading.LoadSpec;
import io.druid.segment.loading.MMappedQueryableSegmentizerFactory;
import io.druid.segment.loading.SegmentLoader;
import io.druid.segment.loading.SegmentLoaderConfig;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.segment.loading.SegmentizerFactory;
import io.druid.segment.loading.StorageLocation;
import io.druid.segment.loading.StorageLocationConfig;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class SegmentLoaderLocalCacheManager
implements SegmentLoader {
    private static final EmittingLogger log = new EmittingLogger(SegmentLoaderLocalCacheManager.class);
    private final IndexIO indexIO;
    private final SegmentLoaderConfig config;
    private final ObjectMapper jsonMapper;
    private final List<StorageLocation> locations;
    private final Object lock = new Object();
    private static final Comparator<StorageLocation> COMPARATOR = new Comparator<StorageLocation>(){

        @Override
        public int compare(StorageLocation left, StorageLocation right) {
            return Longs.compare((long)right.available(), (long)left.available());
        }
    };

    @Inject
    public SegmentLoaderLocalCacheManager(IndexIO indexIO, SegmentLoaderConfig config, @Json ObjectMapper mapper) {
        this.indexIO = indexIO;
        this.config = config;
        this.jsonMapper = mapper;
        this.locations = Lists.newArrayList();
        for (StorageLocationConfig locationConfig : config.getLocations()) {
            this.locations.add(new StorageLocation(locationConfig.getPath(), locationConfig.getMaxSize(), locationConfig.getFreeSpacePercent()));
        }
    }

    public SegmentLoaderLocalCacheManager withConfig(SegmentLoaderConfig config) {
        return new SegmentLoaderLocalCacheManager(this.indexIO, config, this.jsonMapper);
    }

    @Override
    public boolean isSegmentLoaded(DataSegment segment) {
        return this.findStorageLocationIfLoaded(segment) != null;
    }

    public StorageLocation findStorageLocationIfLoaded(DataSegment segment) {
        for (StorageLocation location : this.getSortedList(this.locations)) {
            File localStorageDir = new File(location.getPath(), DataSegmentPusher.getDefaultStorageDir((DataSegment)segment));
            if (!localStorageDir.exists()) continue;
            return location;
        }
        return null;
    }

    @Override
    public Segment getSegment(DataSegment segment) throws SegmentLoadingException {
        MMappedQueryableSegmentizerFactory factory;
        File segmentFiles = this.getSegmentFiles(segment);
        File factoryJson = new File(segmentFiles, "factory.json");
        if (factoryJson.exists()) {
            try {
                factory = (SegmentizerFactory)this.jsonMapper.readValue(factoryJson, SegmentizerFactory.class);
            }
            catch (IOException e) {
                throw new SegmentLoadingException((Throwable)e, "%s", new Object[]{e.getMessage()});
            }
        } else {
            factory = new MMappedQueryableSegmentizerFactory(this.indexIO);
        }
        return factory.factorize(segment, segmentFiles);
    }

    @Override
    public File getSegmentFiles(DataSegment segment) throws SegmentLoadingException {
        StorageLocation loc = this.findStorageLocationIfLoaded(segment);
        String storageDir = DataSegmentPusher.getDefaultStorageDir((DataSegment)segment);
        if (loc == null) {
            loc = this.loadSegmentWithRetry(segment, storageDir);
        }
        loc.addSegment(segment);
        return new File(loc.getPath(), storageDir);
    }

    private StorageLocation loadSegmentWithRetry(DataSegment segment, String storageDirStr) throws SegmentLoadingException {
        for (StorageLocation loc : this.getSortedList(this.locations)) {
            if (!loc.canHandle(segment)) continue;
            File storageDir = new File(loc.getPath(), storageDirStr);
            try {
                this.loadInLocationWithStartMarker(segment, storageDir);
                return loc;
            }
            catch (SegmentLoadingException e) {
                log.makeAlert((Throwable)e, "Failed to load segment in current location %s, try next location if any", new Object[]{loc.getPath().getAbsolutePath()}).addData("location", (Object)loc.getPath().getAbsolutePath()).emit();
                try {
                    this.cleanupCacheFiles(loc.getPath(), storageDir);
                }
                catch (IOException e1) {
                    log.error((Throwable)e1, "Failed to cleanup location " + storageDir.getAbsolutePath(), new Object[0]);
                }
            }
        }
        throw new SegmentLoadingException("Failed to load segment %s in all locations.", new Object[]{segment.getIdentifier()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInLocationWithStartMarker(DataSegment segment, File storageDir) throws SegmentLoadingException {
        File downloadStartMarker = new File(storageDir, "downloadStartMarker");
        Object object = this.lock;
        synchronized (object) {
            if (!storageDir.mkdirs()) {
                log.debug("Unable to make parent file[%s]", new Object[]{storageDir});
            }
            try {
                if (!downloadStartMarker.createNewFile()) {
                    throw new SegmentLoadingException("Was not able to create new download marker for [%s]", new Object[]{storageDir});
                }
            }
            catch (IOException e) {
                throw new SegmentLoadingException((Throwable)e, "Unable to create marker file for [%s]", new Object[]{storageDir});
            }
        }
        this.loadInLocation(segment, storageDir);
        if (!downloadStartMarker.delete()) {
            throw new SegmentLoadingException("Unable to remove marker file for [%s]", new Object[]{storageDir});
        }
    }

    private void loadInLocation(DataSegment segment, File storageDir) throws SegmentLoadingException {
        LoadSpec loadSpec = (LoadSpec)this.jsonMapper.convertValue((Object)segment.getLoadSpec(), LoadSpec.class);
        LoadSpec.LoadSpecResult result = loadSpec.loadSegment(storageDir);
        if (result.getSize() != segment.getSize()) {
            log.warn("Segment [%s] is different than expected size. Expected [%d] found [%d]", new Object[]{segment.getIdentifier(), segment.getSize(), result.getSize()});
        }
    }

    @Override
    public void cleanup(DataSegment segment) throws SegmentLoadingException {
        if (!this.config.isDeleteOnRemove()) {
            return;
        }
        StorageLocation loc = this.findStorageLocationIfLoaded(segment);
        if (loc == null) {
            log.info("Asked to cleanup something[%s] that didn't exist.  Skipping.", new Object[]{segment});
            return;
        }
        try {
            for (StorageLocation location : this.getSortedList(this.locations)) {
                File localStorageDir = new File(location.getPath(), DataSegmentPusher.getDefaultStorageDir((DataSegment)segment));
                if (!localStorageDir.exists()) continue;
                File cacheFile = new File(location.getPath(), DataSegmentPusher.getDefaultStorageDir((DataSegment)segment));
                this.cleanupCacheFiles(location.getPath(), cacheFile);
                location.removeSegment(segment);
            }
        }
        catch (IOException e) {
            throw new SegmentLoadingException((Throwable)e, e.getMessage(), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupCacheFiles(File baseFile, File cacheFile) throws IOException {
        File[] children;
        if (cacheFile.equals(baseFile)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            log.info("Deleting directory[%s]", new Object[]{cacheFile});
            try {
                FileUtils.deleteDirectory((File)cacheFile);
            }
            catch (Exception e) {
                log.error("Unable to remove file[%s]", new Object[]{cacheFile});
            }
        }
        File parent = cacheFile.getParentFile();
        if (parent != null && ((children = parent.listFiles()) == null || children.length == 0)) {
            this.cleanupCacheFiles(baseFile, parent);
        }
    }

    public List<StorageLocation> getSortedList(List<StorageLocation> locs) {
        ArrayList<StorageLocation> locations = new ArrayList<StorageLocation>(locs);
        Collections.sort(locations, COMPARATOR);
        return locations;
    }
}

