/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.druid.java.util.emitter.EmittingLogger;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.java.util.emitter.service.ServiceMetricEvent;
import io.druid.java.util.metrics.AbstractMonitor;
import io.druid.java.util.metrics.MonitorUtils;
import io.druid.segment.realtime.FireDepartment;
import io.druid.segment.realtime.FireDepartmentMetrics;
import java.util.List;
import java.util.Map;

public class RealtimeMetricsMonitor
extends AbstractMonitor {
    private static final EmittingLogger log = new EmittingLogger(RealtimeMetricsMonitor.class);
    private final Map<FireDepartment, FireDepartmentMetrics> previousValues;
    private final List<FireDepartment> fireDepartments;
    private final Map<String, String[]> dimensions;

    @Inject
    public RealtimeMetricsMonitor(List<FireDepartment> fireDepartments) {
        this(fireDepartments, (Map<String, String[]>)ImmutableMap.of());
    }

    public RealtimeMetricsMonitor(List<FireDepartment> fireDepartments, Map<String, String[]> dimensions) {
        this.fireDepartments = fireDepartments;
        this.previousValues = Maps.newHashMap();
        this.dimensions = ImmutableMap.copyOf(dimensions);
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        for (FireDepartment fireDepartment : this.fireDepartments) {
            FireDepartmentMetrics metrics = fireDepartment.getMetrics().snapshot();
            FireDepartmentMetrics previous = this.previousValues.get(fireDepartment);
            if (previous == null) {
                previous = new FireDepartmentMetrics();
            }
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension("dataSource", fireDepartment.getDataSchema().getDataSource());
            MonitorUtils.addDimensionsToBuilder((ServiceMetricEvent.Builder)builder, this.dimensions);
            long thrownAway = metrics.thrownAway() - previous.thrownAway();
            if (thrownAway > 0L) {
                log.warn("[%,d] events thrown away because they are outside the window period!", new Object[]{thrownAway});
            }
            emitter.emit(builder.build("ingest/events/thrownAway", (Number)thrownAway));
            long unparseable = metrics.unparseable() - previous.unparseable();
            if (unparseable > 0L) {
                log.error("[%,d] Unparseable events! Turn on debug logging to see exception stack trace.", new Object[]{unparseable});
            }
            emitter.emit(builder.build("ingest/events/unparseable", (Number)unparseable));
            emitter.emit(builder.build("ingest/events/processed", (Number)(metrics.processed() - previous.processed())));
            emitter.emit(builder.build("ingest/rows/output", (Number)(metrics.rowOutput() - previous.rowOutput())));
            emitter.emit(builder.build("ingest/persists/count", (Number)(metrics.numPersists() - previous.numPersists())));
            emitter.emit(builder.build("ingest/persists/time", (Number)(metrics.persistTimeMillis() - previous.persistTimeMillis())));
            emitter.emit(builder.build("ingest/persists/cpu", (Number)(metrics.persistCpuTime() - previous.persistCpuTime())));
            emitter.emit(builder.build("ingest/persists/backPressure", (Number)(metrics.persistBackPressureMillis() - previous.persistBackPressureMillis())));
            emitter.emit(builder.build("ingest/persists/failed", (Number)(metrics.failedPersists() - previous.failedPersists())));
            emitter.emit(builder.build("ingest/handoff/failed", (Number)(metrics.failedHandoffs() - previous.failedHandoffs())));
            emitter.emit(builder.build("ingest/merge/time", (Number)(metrics.mergeTimeMillis() - previous.mergeTimeMillis())));
            emitter.emit(builder.build("ingest/merge/cpu", (Number)(metrics.mergeCpuTime() - previous.mergeCpuTime())));
            emitter.emit(builder.build("ingest/handoff/count", (Number)(metrics.handOffCount() - previous.handOffCount())));
            emitter.emit(builder.build("ingest/sink/count", (Number)metrics.sinkCount()));
            emitter.emit(builder.build("ingest/events/messageGap", (Number)metrics.messageGap()));
            this.previousValues.put(fireDepartment, metrics);
        }
        return true;
    }
}

