/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.appenderator;

import io.druid.segment.realtime.appenderator.SegmentIdentifier;
import javax.annotation.Nullable;

public class AppenderatorDriverAddResult {
    private final SegmentIdentifier segmentIdentifier;
    private final int numRowsInSegment;
    private final long totalNumRowsInAppenderator;
    private final boolean isPersistRequired;

    public static AppenderatorDriverAddResult ok(SegmentIdentifier segmentIdentifier, int numRowsInSegment, long totalNumRowsInAppenderator, boolean isPersistRequired) {
        return new AppenderatorDriverAddResult(segmentIdentifier, numRowsInSegment, totalNumRowsInAppenderator, isPersistRequired);
    }

    public static AppenderatorDriverAddResult fail() {
        return new AppenderatorDriverAddResult(null, 0, 0L, false);
    }

    private AppenderatorDriverAddResult(@Nullable SegmentIdentifier segmentIdentifier, int numRowsInSegment, long totalNumRowsInAppenderator, boolean isPersistRequired) {
        this.segmentIdentifier = segmentIdentifier;
        this.numRowsInSegment = numRowsInSegment;
        this.totalNumRowsInAppenderator = totalNumRowsInAppenderator;
        this.isPersistRequired = isPersistRequired;
    }

    public boolean isOk() {
        return this.segmentIdentifier != null;
    }

    public SegmentIdentifier getSegmentIdentifier() {
        return this.segmentIdentifier;
    }

    public int getNumRowsInSegment() {
        return this.numRowsInSegment;
    }

    public long getTotalNumRowsInAppenderator() {
        return this.totalNumRowsInAppenderator;
    }

    public boolean isPersistRequired() {
        return this.isPersistRequired;
    }
}

