/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.druid.segment.realtime.appenderator.SegmentIdentifier;
import io.druid.segment.realtime.appenderator.SegmentWithState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AppenderatorDriverMetadata {
    private final Map<String, List<SegmentWithState>> segments;
    private final Map<String, String> lastSegmentIds;
    private final Object callerMetadata;

    @JsonCreator
    public AppenderatorDriverMetadata(@JsonProperty(value="segments") Map<String, List<SegmentWithState>> segments, @JsonProperty(value="lastSegmentIds") Map<String, String> lastSegmentIds, @JsonProperty(value="callerMetadata") Object callerMetadata, @JsonProperty(value="activeSegments") Map<String, List<SegmentIdentifier>> activeSegments, @JsonProperty(value="publishPendingSegments") Map<String, List<SegmentIdentifier>> publishPendingSegments) {
        Preconditions.checkState((segments != null || activeSegments != null && publishPendingSegments != null ? 1 : 0) != 0, (String)"Metadata should either have segments with state information or both active segments and publish pending segments information. segments [%s], activeSegments [%s], publishPendingSegments [%s]", (Object[])new Object[]{segments, activeSegments, publishPendingSegments});
        if (segments == null) {
            HashMap newMetadata = Maps.newHashMap();
            HashSet activeSegmentsAlreadySeen = Sets.newHashSet();
            activeSegments.entrySet().forEach(sequenceSegments -> newMetadata.put(sequenceSegments.getKey(), ((List)sequenceSegments.getValue()).stream().map(segmentIdentifier -> {
                activeSegmentsAlreadySeen.add(segmentIdentifier.toString());
                return SegmentWithState.newSegment(segmentIdentifier);
            }).collect(Collectors.toList())));
            publishPendingSegments.entrySet().forEach(sequenceSegments -> newMetadata.computeIfAbsent(sequenceSegments.getKey(), k -> new ArrayList()).addAll(((List)sequenceSegments.getValue()).stream().filter(segmentIdentifier -> !activeSegmentsAlreadySeen.contains(segmentIdentifier.toString())).map(segmentIdentifier -> SegmentWithState.newSegment(segmentIdentifier, SegmentWithState.SegmentState.APPEND_FINISHED)).collect(Collectors.toList())));
            this.segments = newMetadata;
        } else {
            this.segments = segments;
        }
        this.lastSegmentIds = lastSegmentIds;
        this.callerMetadata = callerMetadata;
    }

    public AppenderatorDriverMetadata(Map<String, List<SegmentWithState>> segments, Map<String, String> lastSegmentIds, Object callerMetadata) {
        this(segments, lastSegmentIds, callerMetadata, null, null);
    }

    @JsonProperty
    public Map<String, List<SegmentWithState>> getSegments() {
        return this.segments;
    }

    @JsonProperty
    public Map<String, String> getLastSegmentIds() {
        return this.lastSegmentIds;
    }

    @JsonProperty
    public Object getCallerMetadata() {
        return this.callerMetadata;
    }

    public String toString() {
        return "AppenderatorDriverMetadata{segments=" + this.segments + ", lastSegmentIds=" + this.lastSegmentIds + ", callerMetadata=" + this.callerMetadata + '}';
    }
}

