/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.RealtimeTuningConfig;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.appenderator.Appenderator;
import io.druid.segment.realtime.appenderator.AppenderatorFactory;
import io.druid.segment.realtime.appenderator.Appenderators;

public class DefaultOfflineAppenderatorFactory
implements AppenderatorFactory {
    private final DataSegmentPusher dataSegmentPusher;
    private final ObjectMapper objectMapper;
    private final IndexIO indexIO;
    private final IndexMerger indexMerger;

    @JsonCreator
    public DefaultOfflineAppenderatorFactory(@JacksonInject DataSegmentPusher dataSegmentPusher, @JacksonInject ObjectMapper objectMapper, @JacksonInject IndexIO indexIO, @JacksonInject IndexMerger indexMerger) {
        this.dataSegmentPusher = dataSegmentPusher;
        this.objectMapper = objectMapper;
        this.indexIO = indexIO;
        this.indexMerger = indexMerger;
    }

    @Override
    public Appenderator build(DataSchema schema, RealtimeTuningConfig config, FireDepartmentMetrics metrics) {
        return Appenderators.createOffline(schema, config, metrics, this.dataSegmentPusher, this.objectMapper, this.indexIO, this.indexMerger);
    }
}

