/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.firehose;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.InputRowParser;
import io.druid.java.util.emitter.EmittingLogger;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class CombiningFirehoseFactory
implements FirehoseFactory<InputRowParser> {
    private static final EmittingLogger log = new EmittingLogger(CombiningFirehoseFactory.class);
    private final List<FirehoseFactory> delegateFactoryList;

    @JsonCreator
    public CombiningFirehoseFactory(@JsonProperty(value="delegates") List<FirehoseFactory> delegateFactoryList) {
        Preconditions.checkArgument((!delegateFactoryList.isEmpty() ? 1 : 0) != 0);
        this.delegateFactoryList = delegateFactoryList;
    }

    public Firehose connect(InputRowParser parser, File temporaryDirectory) throws IOException {
        return new CombiningFirehose(parser, temporaryDirectory);
    }

    @JsonProperty(value="delegates")
    public List<FirehoseFactory> getDelegateFactoryList() {
        return this.delegateFactoryList;
    }

    class CombiningFirehose
    implements Firehose {
        private final InputRowParser parser;
        private final File temporaryDirectory;
        private final Iterator<FirehoseFactory> firehoseFactoryIterator;
        private volatile Firehose currentFirehose;

        CombiningFirehose(InputRowParser parser, File temporaryDirectory) throws IOException {
            this.firehoseFactoryIterator = CombiningFirehoseFactory.this.delegateFactoryList.iterator();
            this.parser = parser;
            this.temporaryDirectory = temporaryDirectory;
            this.nextFirehose();
        }

        private void nextFirehose() {
            if (this.firehoseFactoryIterator.hasNext()) {
                try {
                    if (this.currentFirehose != null) {
                        this.currentFirehose.close();
                    }
                    this.currentFirehose = this.firehoseFactoryIterator.next().connect(this.parser, this.temporaryDirectory);
                }
                catch (IOException e) {
                    if (this.currentFirehose != null) {
                        try {
                            this.currentFirehose.close();
                        }
                        catch (IOException e2) {
                            log.error((Throwable)e, "Unable to close currentFirehose!", new Object[0]);
                            throw Throwables.propagate((Throwable)e2);
                        }
                    }
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }

        public boolean hasMore() {
            return this.currentFirehose.hasMore();
        }

        @Nullable
        public InputRow nextRow() {
            InputRow rv = this.currentFirehose.nextRow();
            if (!this.currentFirehose.hasMore()) {
                this.nextFirehose();
            }
            return rv;
        }

        public Runnable commit() {
            return this.currentFirehose.commit();
        }

        public void close() throws IOException {
            this.currentFirehose.close();
        }
    }
}

