/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.firehose;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.InputRowParser;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;

public class FixedCountFirehoseFactory
implements FirehoseFactory {
    private final FirehoseFactory delegate;
    private final int count;

    @JsonCreator
    public FixedCountFirehoseFactory(@JsonProperty(value="delegate") FirehoseFactory delegate, @JsonProperty(value="count") int count) {
        this.delegate = delegate;
        this.count = count;
    }

    @JsonProperty
    public FirehoseFactory getDelegate() {
        return this.delegate;
    }

    @JsonProperty
    public int getCount() {
        return this.count;
    }

    public Firehose connect(final InputRowParser parser, final File temporaryDirectory) throws IOException {
        return new Firehose(){
            private int i = 0;
            private Firehose delegateFirehose = FixedCountFirehoseFactory.access$000(FixedCountFirehoseFactory.this).connect(parser, temporaryDirectory);

            public boolean hasMore() {
                return this.i < FixedCountFirehoseFactory.this.count && this.delegateFirehose.hasMore();
            }

            @Nullable
            public InputRow nextRow() {
                Preconditions.checkArgument((this.i++ < FixedCountFirehoseFactory.this.count ? 1 : 0) != 0, (Object)"Max events limit reached.");
                return this.delegateFirehose.nextRow();
            }

            public Runnable commit() {
                return this.delegateFirehose.commit();
            }

            public void close() throws IOException {
                this.delegateFirehose.close();
            }
        };
    }

    static /* synthetic */ FirehoseFactory access$000(FixedCountFirehoseFactory x0) {
        return x0.delegate;
    }
}

