/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.firehose;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.data.input.impl.prefetch.PrefetchableTextFilesFirehoseFactory;
import io.druid.java.util.common.CompressionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class HttpFirehoseFactory
extends PrefetchableTextFilesFirehoseFactory<URI> {
    private final List<URI> uris;

    @JsonCreator
    public HttpFirehoseFactory(@JsonProperty(value="uris") List<URI> uris, @JsonProperty(value="maxCacheCapacityBytes") Long maxCacheCapacityBytes, @JsonProperty(value="maxFetchCapacityBytes") Long maxFetchCapacityBytes, @JsonProperty(value="prefetchTriggerBytes") Long prefetchTriggerBytes, @JsonProperty(value="fetchTimeout") Long fetchTimeout, @JsonProperty(value="maxFetchRetry") Integer maxFetchRetry) {
        super(maxCacheCapacityBytes, maxFetchCapacityBytes, prefetchTriggerBytes, fetchTimeout, maxFetchRetry);
        this.uris = uris;
    }

    @JsonProperty
    public List<URI> getUris() {
        return this.uris;
    }

    protected Collection<URI> initObjects() {
        return this.uris;
    }

    protected InputStream openObjectStream(URI object) throws IOException {
        return object.toURL().openConnection().getInputStream();
    }

    protected InputStream wrapObjectStream(URI object, InputStream stream) throws IOException {
        return object.getPath().endsWith(".gz") ? CompressionUtils.gzipInputStream((InputStream)stream) : stream;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        HttpFirehoseFactory that = (HttpFirehoseFactory)((Object)o);
        return Objects.equals(this.uris, that.uris) && this.getMaxCacheCapacityBytes() == that.getMaxCacheCapacityBytes() && this.getMaxFetchCapacityBytes() == that.getMaxFetchCapacityBytes() && this.getPrefetchTriggerBytes() == that.getPrefetchTriggerBytes() && this.getFetchTimeout() == that.getFetchTimeout() && this.getMaxFetchRetry() == that.getMaxFetchRetry();
    }

    public int hashCode() {
        return Objects.hash(this.uris, this.getMaxCacheCapacityBytes(), this.getMaxFetchCapacityBytes(), this.getPrefetchTriggerBytes(), this.getFetchTimeout(), this.getMaxFetchRetry());
    }
}

