/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.firehose;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.druid.data.input.Firehose;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.granularity.Granularities;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.java.util.common.guava.Yielder;
import io.druid.java.util.common.guava.Yielders;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.filter.DimFilter;
import io.druid.segment.BaseLongColumnValueSelector;
import io.druid.segment.BaseObjectColumnValueSelector;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import io.druid.segment.VirtualColumns;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.filter.Filters;
import io.druid.segment.realtime.firehose.WindowedStorageAdapter;
import io.druid.segment.transform.TransformSpec;
import io.druid.segment.transform.Transformer;
import io.druid.utils.Runnables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class IngestSegmentFirehose
implements Firehose {
    private final Transformer transformer;
    private Yielder<InputRow> rowYielder;

    public IngestSegmentFirehose(List<WindowedStorageAdapter> adapters, TransformSpec transformSpec, final List<String> dims, final List<String> metrics, final DimFilter dimFilter) {
        this.transformer = transformSpec.toTransformer();
        Sequence rows = Sequences.concat((Iterable)Iterables.transform(adapters, (Function)new Function<WindowedStorageAdapter, Sequence<InputRow>>(){

            @Nullable
            public Sequence<InputRow> apply(WindowedStorageAdapter adapter) {
                return Sequences.concat((Sequence)Sequences.map((Sequence)adapter.getAdapter().makeCursors(Filters.toFilter((DimFilter)dimFilter), adapter.getInterval(), VirtualColumns.EMPTY, Granularities.ALL, false, null), (Function)new Function<Cursor, Sequence<InputRow>>(){

                    @Nullable
                    public Sequence<InputRow> apply(final Cursor cursor) {
                        ColumnValueSelector timestampColumnSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("__time");
                        HashMap dimSelectors = Maps.newHashMap();
                        for (String dim : dims) {
                            DimensionSelector dimSelector = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec(dim, dim));
                            if (dimSelector == null) continue;
                            dimSelectors.put(dim, dimSelector);
                        }
                        HashMap metSelectors = Maps.newHashMap();
                        for (String metric : metrics) {
                            ColumnValueSelector metricSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector(metric);
                            metSelectors.put(metric, metricSelector);
                        }
                        return Sequences.simple((Iterable)new Iterable<InputRow>((BaseLongColumnValueSelector)timestampColumnSelector, (Map)dimSelectors, (Map)metSelectors){
                            final /* synthetic */ BaseLongColumnValueSelector val$timestampColumnSelector;
                            final /* synthetic */ Map val$dimSelectors;
                            final /* synthetic */ Map val$metSelectors;
                            {
                                this.val$timestampColumnSelector = baseLongColumnValueSelector;
                                this.val$dimSelectors = map;
                                this.val$metSelectors = map2;
                            }

                            @Override
                            public Iterator<InputRow> iterator() {
                                return new Iterator<InputRow>(){

                                    @Override
                                    public boolean hasNext() {
                                        return !cursor.isDone();
                                    }

                                    @Override
                                    public InputRow next() {
                                        DimensionSelector selector;
                                        LinkedHashMap theEvent = Maps.newLinkedHashMap();
                                        long timestamp = val$timestampColumnSelector.getLong();
                                        theEvent.put("timestamp", DateTimes.utc((long)timestamp));
                                        for (Map.Entry dimSelector : val$dimSelectors.entrySet()) {
                                            String dim = (String)dimSelector.getKey();
                                            selector = (DimensionSelector)dimSelector.getValue();
                                            IndexedInts vals = selector.getRow();
                                            if (vals.size() == 1) {
                                                String dimVal = selector.lookupName(vals.get(0));
                                                theEvent.put(dim, dimVal);
                                                continue;
                                            }
                                            ArrayList dimVals = Lists.newArrayList();
                                            for (int i = 0; i < vals.size(); ++i) {
                                                dimVals.add(selector.lookupName(vals.get(i)));
                                            }
                                            theEvent.put(dim, dimVals);
                                        }
                                        for (Map.Entry metSelector : val$metSelectors.entrySet()) {
                                            String metric = (String)metSelector.getKey();
                                            selector = (BaseObjectColumnValueSelector)metSelector.getValue();
                                            Object value = selector.getObject();
                                            if (value == null) continue;
                                            theEvent.put(metric, value);
                                        }
                                        cursor.advance();
                                        return new MapBasedInputRow(timestamp, dims, (Map)theEvent);
                                    }

                                    @Override
                                    public void remove() {
                                        throw new UnsupportedOperationException("Remove Not Supported");
                                    }
                                };
                            }
                        });
                    }
                }));
            }
        }));
        this.rowYielder = Yielders.each((Sequence)rows);
    }

    public boolean hasMore() {
        return !this.rowYielder.isDone();
    }

    @Nullable
    public InputRow nextRow() {
        InputRow inputRow = (InputRow)this.rowYielder.get();
        this.rowYielder = this.rowYielder.next(null);
        return this.transformer.transform(inputRow);
    }

    public Runnable commit() {
        return Runnables.getNoopRunnable();
    }

    public void close() throws IOException {
        this.rowYielder.close();
    }
}

