/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.firehose;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.druid.data.input.impl.AbstractTextFilesFirehoseFactory;
import io.druid.data.input.impl.StringInputRowParser;
import io.druid.java.util.common.CompressionUtils;
import io.druid.java.util.emitter.EmittingLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class LocalFirehoseFactory
extends AbstractTextFilesFirehoseFactory<File> {
    private static final EmittingLogger log = new EmittingLogger(LocalFirehoseFactory.class);
    private final File baseDir;
    private final String filter;
    private final StringInputRowParser parser;

    @JsonCreator
    public LocalFirehoseFactory(@JsonProperty(value="baseDir") File baseDir, @JsonProperty(value="filter") String filter, @JsonProperty(value="parser") StringInputRowParser parser) {
        this.baseDir = baseDir;
        this.filter = filter;
        this.parser = parser;
    }

    @JsonProperty
    public File getBaseDir() {
        return this.baseDir;
    }

    @JsonProperty
    public String getFilter() {
        return this.filter;
    }

    @JsonProperty
    public StringInputRowParser getParser() {
        return this.parser;
    }

    protected Collection<File> initObjects() {
        Collection files = FileUtils.listFiles((File)((File)Preconditions.checkNotNull((Object)this.baseDir)).getAbsoluteFile(), (IOFileFilter)new WildcardFileFilter(this.filter), (IOFileFilter)TrueFileFilter.INSTANCE);
        log.info("Initialized with " + files + " files", new Object[0]);
        return files;
    }

    protected InputStream openObjectStream(File object) throws IOException {
        return FileUtils.openInputStream((File)object);
    }

    protected InputStream wrapObjectStream(File object, InputStream stream) throws IOException {
        return object.getPath().endsWith(".gz") ? CompressionUtils.gzipInputStream((InputStream)stream) : stream;
    }
}

