/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.druid.client.CachingClusteredClient;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.query.FluentQueryRunnerBuilder;
import io.druid.query.PostProcessingOperator;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryToolChestWarehouse;
import io.druid.query.RetryQueryRunner;
import io.druid.query.RetryQueryRunnerConfig;
import io.druid.query.SegmentDescriptor;
import io.druid.server.SetAndVerifyContextQueryRunner;
import io.druid.server.initialization.ServerConfig;
import org.joda.time.Interval;

public class ClientQuerySegmentWalker
implements QuerySegmentWalker {
    private final ServiceEmitter emitter;
    private final CachingClusteredClient baseClient;
    private final QueryToolChestWarehouse warehouse;
    private final RetryQueryRunnerConfig retryConfig;
    private final ObjectMapper objectMapper;
    private final ServerConfig serverConfig;

    @Inject
    public ClientQuerySegmentWalker(ServiceEmitter emitter, CachingClusteredClient baseClient, QueryToolChestWarehouse warehouse, RetryQueryRunnerConfig retryConfig, ObjectMapper objectMapper, ServerConfig serverConfig) {
        this.emitter = emitter;
        this.baseClient = baseClient;
        this.warehouse = warehouse;
        this.retryConfig = retryConfig;
        this.objectMapper = objectMapper;
        this.serverConfig = serverConfig;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        return this.makeRunner(query, this.baseClient.getQueryRunnerForIntervals(query, intervals));
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        return this.makeRunner(query, this.baseClient.getQueryRunnerForSegments(query, specs));
    }

    private <T> QueryRunner<T> makeRunner(Query<T> query, QueryRunner<T> baseClientRunner) {
        QueryToolChest toolChest = this.warehouse.getToolChest(query);
        PostProcessingOperator postProcessing = (PostProcessingOperator)this.objectMapper.convertValue(query.getContextValue("postProcessing"), new TypeReference<PostProcessingOperator<T>>(){});
        return new FluentQueryRunnerBuilder(toolChest).create((QueryRunner)new SetAndVerifyContextQueryRunner(this.serverConfig, (QueryRunner)new RetryQueryRunner(baseClientRunner, this.retryConfig, this.objectMapper))).applyPreMergeDecoration().mergeResults().applyPostMergeDecoration().emitCPUTimeMetric(this.emitter).postProcess(postProcessing);
    }
}

