/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordination;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.druid.curator.announcement.Announcer;
import io.druid.java.util.common.logger.Logger;
import io.druid.server.coordination.DataSegmentServerAnnouncer;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.server.initialization.ZkPathsConfig;
import org.apache.curator.utils.ZKPaths;

@Deprecated
public class CuratorDataSegmentServerAnnouncer
implements DataSegmentServerAnnouncer {
    private static final Logger log = new Logger(CuratorDataSegmentServerAnnouncer.class);
    private final DruidServerMetadata server;
    private final ZkPathsConfig config;
    private final Announcer announcer;
    private final ObjectMapper jsonMapper;
    private final Object lock = new Object();
    private volatile boolean announced = false;

    @Inject
    public CuratorDataSegmentServerAnnouncer(DruidServerMetadata server, ZkPathsConfig config, Announcer announcer, ObjectMapper jsonMapper) {
        this.server = server;
        this.config = config;
        this.announcer = announcer;
        this.jsonMapper = jsonMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void announce() {
        Object object = this.lock;
        synchronized (object) {
            if (this.announced) {
                return;
            }
            try {
                String path = this.makeAnnouncementPath();
                log.info("Announcing self[%s] at [%s]", new Object[]{this.server, path});
                this.announcer.announce(path, this.jsonMapper.writeValueAsBytes((Object)this.server), false);
            }
            catch (JsonProcessingException e) {
                throw Throwables.propagate((Throwable)e);
            }
            this.announced = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unannounce() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.announced) {
                return;
            }
            String path = this.makeAnnouncementPath();
            log.info("Unannouncing self[%s] at [%s]", new Object[]{this.server, path});
            this.announcer.unannounce(path);
            this.announced = false;
        }
    }

    private String makeAnnouncementPath() {
        return ZKPaths.makePath((String)this.config.getAnnouncementsPath(), (String)this.server.getName());
    }
}

