/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordination;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import io.druid.client.CachingQueryRunner;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheConfig;
import io.druid.guice.annotations.BackgroundCaching;
import io.druid.guice.annotations.Processing;
import io.druid.guice.annotations.Smile;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.guava.FunctionalIterable;
import io.druid.java.util.emitter.EmittingLogger;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.query.BySegmentQueryRunner;
import io.druid.query.CPUTimeMetricQueryRunner;
import io.druid.query.DataSource;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.MetricsEmittingQueryRunner;
import io.druid.query.NoopQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryMetrics;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.QueryToolChest;
import io.druid.query.ReferenceCountingSegmentQueryRunner;
import io.druid.query.ReportTimelineMissingSegmentQueryRunner;
import io.druid.query.SegmentDescriptor;
import io.druid.query.TableDataSource;
import io.druid.query.spec.SpecificSegmentQueryRunner;
import io.druid.query.spec.SpecificSegmentSpec;
import io.druid.segment.ReferenceCountingSegment;
import io.druid.server.SegmentManager;
import io.druid.server.SetAndVerifyContextQueryRunner;
import io.druid.server.initialization.ServerConfig;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import io.druid.timeline.partition.PartitionChunk;
import io.druid.timeline.partition.PartitionHolder;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.joda.time.Interval;

public class ServerManager
implements QuerySegmentWalker {
    private static final EmittingLogger log = new EmittingLogger(ServerManager.class);
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final ServiceEmitter emitter;
    private final ExecutorService exec;
    private final ExecutorService cachingExec;
    private final Cache cache;
    private final ObjectMapper objectMapper;
    private final CacheConfig cacheConfig;
    private final SegmentManager segmentManager;
    private final ServerConfig serverConfig;

    @Inject
    public ServerManager(QueryRunnerFactoryConglomerate conglomerate, ServiceEmitter emitter, @Processing ExecutorService exec, @BackgroundCaching ExecutorService cachingExec, @Smile ObjectMapper objectMapper, Cache cache, CacheConfig cacheConfig, SegmentManager segmentManager, ServerConfig serverConfig) {
        this.conglomerate = conglomerate;
        this.emitter = emitter;
        this.exec = exec;
        this.cachingExec = cachingExec;
        this.cache = cache;
        this.objectMapper = objectMapper;
        this.cacheConfig = cacheConfig;
        this.segmentManager = segmentManager;
        this.serverConfig = serverConfig;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        final QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            throw new ISE("Unknown query type[%s].", new Object[]{query.getClass()});
        }
        final QueryToolChest toolChest = factory.getToolchest();
        final AtomicLong cpuTimeAccumulator = new AtomicLong(0L);
        DataSource dataSource = query.getDataSource();
        if (!(dataSource instanceof TableDataSource)) {
            throw new UnsupportedOperationException("data source type '" + dataSource.getClass().getName() + "' unsupported");
        }
        String dataSourceName = this.getDataSourceName(dataSource);
        final VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = this.segmentManager.getTimeline(dataSourceName);
        if (timeline == null) {
            return new NoopQueryRunner();
        }
        FunctionalIterable queryRunners = FunctionalIterable.create(intervals).transformCat((Function)new Function<Interval, Iterable<TimelineObjectHolder<String, ReferenceCountingSegment>>>(){

            public Iterable<TimelineObjectHolder<String, ReferenceCountingSegment>> apply(Interval input) {
                return timeline.lookup(input);
            }
        }).transformCat(new Function<TimelineObjectHolder<String, ReferenceCountingSegment>, Iterable<QueryRunner<T>>>(){

            public Iterable<QueryRunner<T>> apply(final @Nullable TimelineObjectHolder<String, ReferenceCountingSegment> holder) {
                if (holder == null) {
                    return null;
                }
                return FunctionalIterable.create((Iterable)holder.getObject()).transform(new Function<PartitionChunk<ReferenceCountingSegment>, QueryRunner<T>>(){

                    public QueryRunner<T> apply(PartitionChunk<ReferenceCountingSegment> input) {
                        return ServerManager.this.buildAndDecorateQueryRunner(factory, toolChest, (ReferenceCountingSegment)input.getObject(), new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), input.getChunkNumber()), cpuTimeAccumulator);
                    }
                });
            }
        });
        return CPUTimeMetricQueryRunner.safeBuild((QueryRunner)new FinalizeResultsQueryRunner(toolChest.mergeResults(factory.mergeRunners(this.exec, (Iterable)queryRunners)), toolChest), (QueryToolChest)toolChest, (ServiceEmitter)this.emitter, (AtomicLong)cpuTimeAccumulator, (boolean)true);
    }

    private String getDataSourceName(DataSource dataSource) {
        return (String)Iterables.getOnlyElement((Iterable)dataSource.getNames());
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        final QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            log.makeAlert("Unknown query type, [%s]", new Object[]{query.getClass()}).addData("dataSource", (Object)query.getDataSource()).emit();
            return new NoopQueryRunner();
        }
        final QueryToolChest toolChest = factory.getToolchest();
        String dataSourceName = this.getDataSourceName(query.getDataSource());
        final VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = this.segmentManager.getTimeline(dataSourceName);
        if (timeline == null) {
            return new NoopQueryRunner();
        }
        final AtomicLong cpuTimeAccumulator = new AtomicLong(0L);
        FunctionalIterable queryRunners = FunctionalIterable.create(specs).transformCat(new Function<SegmentDescriptor, Iterable<QueryRunner<T>>>(){

            public Iterable<QueryRunner<T>> apply(SegmentDescriptor input) {
                PartitionHolder entry = timeline.findEntry(input.getInterval(), (Object)input.getVersion());
                if (entry == null) {
                    return Arrays.asList(new ReportTimelineMissingSegmentQueryRunner(input));
                }
                PartitionChunk chunk = entry.getChunk(input.getPartitionNumber());
                if (chunk == null) {
                    return Collections.singletonList(new ReportTimelineMissingSegmentQueryRunner(input));
                }
                ReferenceCountingSegment adapter = (ReferenceCountingSegment)chunk.getObject();
                return Collections.singletonList(ServerManager.this.buildAndDecorateQueryRunner(factory, toolChest, adapter, input, cpuTimeAccumulator));
            }
        });
        return CPUTimeMetricQueryRunner.safeBuild((QueryRunner)new FinalizeResultsQueryRunner(toolChest.mergeResults(factory.mergeRunners(this.exec, (Iterable)queryRunners)), toolChest), (QueryToolChest)toolChest, (ServiceEmitter)this.emitter, (AtomicLong)cpuTimeAccumulator, (boolean)true);
    }

    private <T> QueryRunner<T> buildAndDecorateQueryRunner(QueryRunnerFactory<T, Query<T>> factory, QueryToolChest<T, Query<T>> toolChest, ReferenceCountingSegment adapter, SegmentDescriptor segmentDescriptor, AtomicLong cpuTimeAccumulator) {
        SpecificSegmentSpec segmentSpec = new SpecificSegmentSpec(segmentDescriptor);
        String segmentId = adapter.getIdentifier();
        return new SetAndVerifyContextQueryRunner(this.serverConfig, CPUTimeMetricQueryRunner.safeBuild((QueryRunner)new SpecificSegmentQueryRunner((QueryRunner)new MetricsEmittingQueryRunner(this.emitter, toolChest, (QueryRunner)new BySegmentQueryRunner(segmentId, adapter.getDataInterval().getStart(), new CachingQueryRunner(segmentId, segmentDescriptor, this.objectMapper, this.cache, (QueryToolChest)toolChest, new MetricsEmittingQueryRunner(this.emitter, toolChest, (QueryRunner)new ReferenceCountingSegmentQueryRunner(factory, adapter, segmentDescriptor), QueryMetrics::reportSegmentTime, queryMetrics -> queryMetrics.segment(segmentId)), this.cachingExec, this.cacheConfig)), QueryMetrics::reportSegmentAndCacheTime, queryMetrics -> queryMetrics.segment(segmentId)).withWaitMeasuredFromNow(), segmentSpec), toolChest, (ServiceEmitter)this.emitter, (AtomicLong)cpuTimeAccumulator, (boolean)false));
    }
}

