/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordination.broker;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import io.druid.client.FilteredServerInventoryView;
import io.druid.client.ServerView;
import io.druid.curator.discovery.ServiceAnnouncer;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.Self;
import io.druid.java.util.common.Pair;
import io.druid.java.util.common.lifecycle.LifecycleStart;
import io.druid.java.util.common.lifecycle.LifecycleStop;
import io.druid.server.DruidNode;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.timeline.DataSegment;
import java.util.concurrent.Executor;

@ManageLifecycle
public class DruidBroker {
    private final DruidNode self;
    private final ServiceAnnouncer serviceAnnouncer;
    private volatile boolean started = false;

    @Inject
    public DruidBroker(FilteredServerInventoryView serverInventoryView, final @Self DruidNode self, final ServiceAnnouncer serviceAnnouncer) {
        this.self = self;
        this.serviceAnnouncer = serviceAnnouncer;
        serverInventoryView.registerSegmentCallback((Executor)MoreExecutors.sameThreadExecutor(), new ServerView.BaseSegmentCallback(){

            @Override
            public ServerView.CallbackAction segmentViewInitialized() {
                serviceAnnouncer.announce(self);
                return ServerView.CallbackAction.UNREGISTER;
            }
        }, (Predicate<Pair<DruidServerMetadata, DataSegment>>)Predicates.alwaysFalse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        DruidNode druidNode = this.self;
        synchronized (druidNode) {
            if (this.started) {
                return;
            }
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        DruidNode druidNode = this.self;
        synchronized (druidNode) {
            if (!this.started) {
                return;
            }
            this.serviceAnnouncer.unannounce(this.self);
            this.started = false;
        }
    }
}

