/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import io.druid.java.util.common.IAE;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class CoordinatorDynamicConfig {
    public static final String CONFIG_KEY = "coordinator.config";
    private final long millisToWaitBeforeDeleting;
    private final long mergeBytesLimit;
    private final int mergeSegmentsLimit;
    private final int maxSegmentsToMove;
    private final int replicantLifetime;
    private final int replicationThrottleLimit;
    private final int balancerComputeThreads;
    private final boolean emitBalancingStats;
    private final boolean killAllDataSources;
    private final Set<String> killDataSourceWhitelist;
    private final Set<String> killPendingSegmentsSkipList;
    private final int maxSegmentsInNodeLoadingQueue;

    @JsonCreator
    public CoordinatorDynamicConfig(@JsonProperty(value="millisToWaitBeforeDeleting") long millisToWaitBeforeDeleting, @JsonProperty(value="mergeBytesLimit") long mergeBytesLimit, @JsonProperty(value="mergeSegmentsLimit") int mergeSegmentsLimit, @JsonProperty(value="maxSegmentsToMove") int maxSegmentsToMove, @JsonProperty(value="replicantLifetime") int replicantLifetime, @JsonProperty(value="replicationThrottleLimit") int replicationThrottleLimit, @JsonProperty(value="balancerComputeThreads") int balancerComputeThreads, @JsonProperty(value="emitBalancingStats") boolean emitBalancingStats, @JsonProperty(value="killDataSourceWhitelist") Object killDataSourceWhitelist, @JsonProperty(value="killPendingSegmentsSkipList") Object killPendingSegmentsSkipList, @JsonProperty(value="killAllDataSources") boolean killAllDataSources, @JsonProperty(value="maxSegmentsInNodeLoadingQueue") int maxSegmentsInNodeLoadingQueue) {
        this.millisToWaitBeforeDeleting = millisToWaitBeforeDeleting;
        this.mergeBytesLimit = mergeBytesLimit;
        this.mergeSegmentsLimit = mergeSegmentsLimit;
        this.maxSegmentsToMove = maxSegmentsToMove;
        this.replicantLifetime = replicantLifetime;
        this.replicationThrottleLimit = replicationThrottleLimit;
        this.balancerComputeThreads = Math.max(balancerComputeThreads, 1);
        this.emitBalancingStats = emitBalancingStats;
        this.killAllDataSources = killAllDataSources;
        this.killDataSourceWhitelist = CoordinatorDynamicConfig.parseJsonStringOrArray(killDataSourceWhitelist);
        this.killPendingSegmentsSkipList = CoordinatorDynamicConfig.parseJsonStringOrArray(killPendingSegmentsSkipList);
        this.maxSegmentsInNodeLoadingQueue = maxSegmentsInNodeLoadingQueue;
        if (this.killAllDataSources && !this.killDataSourceWhitelist.isEmpty()) {
            throw new IAE("can't have killAllDataSources and non-empty killDataSourceWhitelist", new Object[0]);
        }
    }

    private static Set<String> parseJsonStringOrArray(Object jsonStringOrArray) {
        if (jsonStringOrArray instanceof String) {
            String[] list = ((String)jsonStringOrArray).split(",");
            HashSet<String> result = new HashSet<String>();
            for (String item : list) {
                String trimmed = item.trim();
                if (trimmed.isEmpty()) continue;
                result.add(trimmed);
            }
            return result;
        }
        if (jsonStringOrArray instanceof Collection) {
            return ImmutableSet.copyOf((Collection)((Collection)jsonStringOrArray));
        }
        return ImmutableSet.of();
    }

    @JsonProperty
    public long getMillisToWaitBeforeDeleting() {
        return this.millisToWaitBeforeDeleting;
    }

    @JsonProperty
    public long getMergeBytesLimit() {
        return this.mergeBytesLimit;
    }

    @JsonProperty
    public boolean emitBalancingStats() {
        return this.emitBalancingStats;
    }

    @JsonProperty
    public int getMergeSegmentsLimit() {
        return this.mergeSegmentsLimit;
    }

    @JsonProperty
    public int getMaxSegmentsToMove() {
        return this.maxSegmentsToMove;
    }

    @JsonProperty
    public int getReplicantLifetime() {
        return this.replicantLifetime;
    }

    @JsonProperty
    public int getReplicationThrottleLimit() {
        return this.replicationThrottleLimit;
    }

    @JsonProperty
    public int getBalancerComputeThreads() {
        return this.balancerComputeThreads;
    }

    @JsonProperty
    public Set<String> getKillDataSourceWhitelist() {
        return this.killDataSourceWhitelist;
    }

    @JsonProperty
    public Set<String> getKillPendingSegmentsSkipList() {
        return this.killPendingSegmentsSkipList;
    }

    @JsonProperty
    public boolean isKillAllDataSources() {
        return this.killAllDataSources;
    }

    @JsonProperty
    public int getMaxSegmentsInNodeLoadingQueue() {
        return this.maxSegmentsInNodeLoadingQueue;
    }

    public String toString() {
        return "CoordinatorDynamicConfig{millisToWaitBeforeDeleting=" + this.millisToWaitBeforeDeleting + ", mergeBytesLimit=" + this.mergeBytesLimit + ", mergeSegmentsLimit=" + this.mergeSegmentsLimit + ", maxSegmentsToMove=" + this.maxSegmentsToMove + ", replicantLifetime=" + this.replicantLifetime + ", replicationThrottleLimit=" + this.replicationThrottleLimit + ", balancerComputeThreads=" + this.balancerComputeThreads + ", emitBalancingStats=" + this.emitBalancingStats + ", killDataSourceWhitelist=" + this.killDataSourceWhitelist + ", killPendingSegmentsSkipList=" + this.killPendingSegmentsSkipList + ", killAllDataSources=" + this.killAllDataSources + ", maxSegmentsInNodeLoadingQueue=" + this.maxSegmentsInNodeLoadingQueue + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinatorDynamicConfig that = (CoordinatorDynamicConfig)o;
        if (this.millisToWaitBeforeDeleting != that.millisToWaitBeforeDeleting) {
            return false;
        }
        if (this.mergeBytesLimit != that.mergeBytesLimit) {
            return false;
        }
        if (this.mergeSegmentsLimit != that.mergeSegmentsLimit) {
            return false;
        }
        if (this.maxSegmentsToMove != that.maxSegmentsToMove) {
            return false;
        }
        if (this.replicantLifetime != that.replicantLifetime) {
            return false;
        }
        if (this.replicationThrottleLimit != that.replicationThrottleLimit) {
            return false;
        }
        if (this.balancerComputeThreads != that.balancerComputeThreads) {
            return false;
        }
        if (this.emitBalancingStats != that.emitBalancingStats) {
            return false;
        }
        if (this.killAllDataSources != that.killAllDataSources) {
            return false;
        }
        if (this.maxSegmentsInNodeLoadingQueue != that.maxSegmentsInNodeLoadingQueue) {
            return false;
        }
        if (!Objects.equals(this.killDataSourceWhitelist, that.killDataSourceWhitelist)) {
            return false;
        }
        return Objects.equals(this.killPendingSegmentsSkipList, that.killPendingSegmentsSkipList);
    }

    public int hashCode() {
        return Objects.hash(this.millisToWaitBeforeDeleting, this.mergeBytesLimit, this.mergeSegmentsLimit, this.maxSegmentsToMove, this.replicantLifetime, this.replicationThrottleLimit, this.balancerComputeThreads, this.emitBalancingStats, this.killAllDataSources, this.maxSegmentsInNodeLoadingQueue, this.killDataSourceWhitelist, this.killPendingSegmentsSkipList);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final long DEFAULT_MILLIS_TO_WAIT_BEFORE_DELETING = TimeUnit.MINUTES.toMillis(15L);
        private static final long DEFAULT_MERGE_BYTES_LIMIT = 524288000L;
        private static final int DEFAULT_MERGE_SEGMENTS_LIMIT = 100;
        private static final int DEFAULT_MAX_SEGMENTS_TO_MOVE = 5;
        private static final int DEFAULT_REPLICANT_LIFETIME = 15;
        private static final int DEFAULT_REPLICATION_THROTTLE_LIMIT = 10;
        private static final int DEFAULT_BALANCER_COMPUTE_THREADS = 1;
        private static final boolean DEFAULT_EMIT_BALANCING_STATS = false;
        private static final boolean DEFAULT_KILL_ALL_DATA_SOURCES = false;
        private static final int DEFAULT_MAX_SEGMENTS_IN_NODE_LOADING_QUEUE = 0;
        private Long millisToWaitBeforeDeleting;
        private Long mergeBytesLimit;
        private Integer mergeSegmentsLimit;
        private Integer maxSegmentsToMove;
        private Integer replicantLifetime;
        private Integer replicationThrottleLimit;
        private Boolean emitBalancingStats;
        private Integer balancerComputeThreads;
        private Object killDataSourceWhitelist;
        private Object killPendingSegmentsSkipList;
        private Boolean killAllDataSources;
        private Integer maxSegmentsInNodeLoadingQueue;

        public Builder() {
        }

        @JsonCreator
        public Builder(@JsonProperty(value="millisToWaitBeforeDeleting") Long millisToWaitBeforeDeleting, @JsonProperty(value="mergeBytesLimit") Long mergeBytesLimit, @JsonProperty(value="mergeSegmentsLimit") Integer mergeSegmentsLimit, @JsonProperty(value="maxSegmentsToMove") Integer maxSegmentsToMove, @JsonProperty(value="replicantLifetime") Integer replicantLifetime, @JsonProperty(value="replicationThrottleLimit") Integer replicationThrottleLimit, @JsonProperty(value="balancerComputeThreads") Integer balancerComputeThreads, @JsonProperty(value="emitBalancingStats") Boolean emitBalancingStats, @JsonProperty(value="killDataSourceWhitelist") Object killDataSourceWhitelist, @JsonProperty(value="killPendingSegmentsSkipList") Object killPendingSegmentsSkipList, @JsonProperty(value="killAllDataSources") Boolean killAllDataSources, @JsonProperty(value="maxSegmentsInNodeLoadingQueue") Integer maxSegmentsInNodeLoadingQueue) {
            this.millisToWaitBeforeDeleting = millisToWaitBeforeDeleting;
            this.mergeBytesLimit = mergeBytesLimit;
            this.mergeSegmentsLimit = mergeSegmentsLimit;
            this.maxSegmentsToMove = maxSegmentsToMove;
            this.replicantLifetime = replicantLifetime;
            this.replicationThrottleLimit = replicationThrottleLimit;
            this.balancerComputeThreads = balancerComputeThreads;
            this.emitBalancingStats = emitBalancingStats;
            this.killAllDataSources = killAllDataSources;
            this.killDataSourceWhitelist = killDataSourceWhitelist;
            this.killPendingSegmentsSkipList = killPendingSegmentsSkipList;
            this.maxSegmentsInNodeLoadingQueue = maxSegmentsInNodeLoadingQueue;
        }

        public Builder withMillisToWaitBeforeDeleting(long millisToWaitBeforeDeleting) {
            this.millisToWaitBeforeDeleting = millisToWaitBeforeDeleting;
            return this;
        }

        public Builder withMergeBytesLimit(long mergeBytesLimit) {
            this.mergeBytesLimit = mergeBytesLimit;
            return this;
        }

        public Builder withMergeSegmentsLimit(int mergeSegmentsLimit) {
            this.mergeSegmentsLimit = mergeSegmentsLimit;
            return this;
        }

        public Builder withMaxSegmentsToMove(int maxSegmentsToMove) {
            this.maxSegmentsToMove = maxSegmentsToMove;
            return this;
        }

        public Builder withReplicantLifetime(int replicantLifetime) {
            this.replicantLifetime = replicantLifetime;
            return this;
        }

        public Builder withReplicationThrottleLimit(int replicationThrottleLimit) {
            this.replicationThrottleLimit = replicationThrottleLimit;
            return this;
        }

        public Builder withBalancerComputeThreads(int balancerComputeThreads) {
            this.balancerComputeThreads = balancerComputeThreads;
            return this;
        }

        public Builder withEmitBalancingStats(boolean emitBalancingStats) {
            this.emitBalancingStats = emitBalancingStats;
            return this;
        }

        public Builder withKillDataSourceWhitelist(Set<String> killDataSourceWhitelist) {
            this.killDataSourceWhitelist = killDataSourceWhitelist;
            return this;
        }

        public Builder withKillAllDataSources(boolean killAllDataSources) {
            this.killAllDataSources = killAllDataSources;
            return this;
        }

        public Builder withMaxSegmentsInNodeLoadingQueue(int maxSegmentsInNodeLoadingQueue) {
            this.maxSegmentsInNodeLoadingQueue = maxSegmentsInNodeLoadingQueue;
            return this;
        }

        public CoordinatorDynamicConfig build() {
            return new CoordinatorDynamicConfig(this.millisToWaitBeforeDeleting == null ? DEFAULT_MILLIS_TO_WAIT_BEFORE_DELETING : this.millisToWaitBeforeDeleting, this.mergeBytesLimit == null ? 524288000L : this.mergeBytesLimit, this.mergeSegmentsLimit == null ? 100 : this.mergeSegmentsLimit, this.maxSegmentsToMove == null ? 5 : this.maxSegmentsToMove, this.replicantLifetime == null ? 15 : this.replicantLifetime, this.replicationThrottleLimit == null ? 10 : this.replicationThrottleLimit, this.balancerComputeThreads == null ? 1 : this.balancerComputeThreads, this.emitBalancingStats == null ? false : this.emitBalancingStats, this.killDataSourceWhitelist, this.killPendingSegmentsSkipList, this.killAllDataSources == null ? false : this.killAllDataSources, this.maxSegmentsInNodeLoadingQueue == null ? 0 : this.maxSegmentsInNodeLoadingQueue);
        }

        public CoordinatorDynamicConfig build(CoordinatorDynamicConfig defaults) {
            return new CoordinatorDynamicConfig(this.millisToWaitBeforeDeleting == null ? defaults.getMillisToWaitBeforeDeleting() : this.millisToWaitBeforeDeleting.longValue(), this.mergeBytesLimit == null ? defaults.getMergeBytesLimit() : this.mergeBytesLimit.longValue(), this.mergeSegmentsLimit == null ? defaults.getMergeSegmentsLimit() : this.mergeSegmentsLimit.intValue(), this.maxSegmentsToMove == null ? defaults.getMaxSegmentsToMove() : this.maxSegmentsToMove.intValue(), this.replicantLifetime == null ? defaults.getReplicantLifetime() : this.replicantLifetime.intValue(), this.replicationThrottleLimit == null ? defaults.getReplicationThrottleLimit() : this.replicationThrottleLimit.intValue(), this.balancerComputeThreads == null ? defaults.getBalancerComputeThreads() : this.balancerComputeThreads.intValue(), this.emitBalancingStats == null ? defaults.emitBalancingStats() : this.emitBalancingStats.booleanValue(), this.killDataSourceWhitelist == null ? defaults.getKillDataSourceWhitelist() : this.killDataSourceWhitelist, this.killPendingSegmentsSkipList == null ? defaults.getKillPendingSegmentsSkipList() : this.killPendingSegmentsSkipList, this.killAllDataSources == null ? defaults.isKillAllDataSources() : this.killAllDataSources.booleanValue(), this.maxSegmentsInNodeLoadingQueue == null ? defaults.getMaxSegmentsInNodeLoadingQueue() : this.maxSegmentsInNodeLoadingQueue.intValue());
        }
    }
}

