/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.concurrent.ScheduledExecutors;
import io.druid.java.util.emitter.EmittingLogger;
import io.druid.server.coordination.DataSegmentChangeRequest;
import io.druid.server.coordination.SegmentChangeRequestDrop;
import io.druid.server.coordination.SegmentChangeRequestLoad;
import io.druid.server.coordination.SegmentChangeRequestNoop;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.coordinator.DruidCoordinatorConfig;
import io.druid.server.coordinator.LoadPeonCallback;
import io.druid.server.coordinator.LoadQueuePeon;
import io.druid.timeline.DataSegment;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.data.Stat;
import org.joda.time.Duration;

@Deprecated
public class CuratorLoadQueuePeon
extends LoadQueuePeon {
    private static final EmittingLogger log = new EmittingLogger(CuratorLoadQueuePeon.class);
    private static final int DROP = 0;
    private static final int LOAD = 1;
    private final CuratorFramework curator;
    private final String basePath;
    private final ObjectMapper jsonMapper;
    private final ScheduledExecutorService processingExecutor;
    private final ExecutorService callBackExecutor;
    private final DruidCoordinatorConfig config;
    private final AtomicLong queuedSize = new AtomicLong(0L);
    private final AtomicInteger failedAssignCount = new AtomicInteger(0);
    private final ConcurrentSkipListMap<DataSegment, SegmentHolder> segmentsToLoad = new ConcurrentSkipListMap(DruidCoordinator.SEGMENT_COMPARATOR);
    private final ConcurrentSkipListMap<DataSegment, SegmentHolder> segmentsToDrop = new ConcurrentSkipListMap(DruidCoordinator.SEGMENT_COMPARATOR);
    private final ConcurrentSkipListSet<DataSegment> segmentsMarkedToDrop = new ConcurrentSkipListSet<DataSegment>(DruidCoordinator.SEGMENT_COMPARATOR);
    private final Object lock = new Object();
    private volatile SegmentHolder currentlyProcessing = null;
    private boolean stopped = false;

    private static void executeCallbacks(List<LoadPeonCallback> callbacks) {
        for (LoadPeonCallback callback : callbacks) {
            if (callback == null) continue;
            callback.execute();
        }
    }

    CuratorLoadQueuePeon(CuratorFramework curator, String basePath, ObjectMapper jsonMapper, ScheduledExecutorService processingExecutor, ExecutorService callbackExecutor, DruidCoordinatorConfig config) {
        this.curator = curator;
        this.basePath = basePath;
        this.jsonMapper = jsonMapper;
        this.callBackExecutor = callbackExecutor;
        this.processingExecutor = processingExecutor;
        this.config = config;
    }

    @Override
    @JsonProperty
    public Set<DataSegment> getSegmentsToLoad() {
        return this.segmentsToLoad.keySet();
    }

    @Override
    @JsonProperty
    public Set<DataSegment> getSegmentsToDrop() {
        return this.segmentsToDrop.keySet();
    }

    @Override
    @JsonProperty
    public Set<DataSegment> getSegmentsMarkedToDrop() {
        return this.segmentsMarkedToDrop;
    }

    @Override
    public long getLoadQueueSize() {
        return this.queuedSize.get();
    }

    @Override
    public int getAndResetFailedAssignCount() {
        return this.failedAssignCount.getAndSet(0);
    }

    @Override
    public int getNumberOfSegmentsInQueue() {
        return this.segmentsToLoad.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadSegment(DataSegment segment, LoadPeonCallback callback) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentlyProcessing != null && this.currentlyProcessing.getSegmentIdentifier().equals(segment.getIdentifier())) {
                if (callback != null) {
                    this.currentlyProcessing.addCallback(callback);
                }
                return;
            }
        }
        object = this.lock;
        synchronized (object) {
            SegmentHolder existingHolder = this.segmentsToLoad.get(segment);
            if (existingHolder != null) {
                if (callback != null) {
                    existingHolder.addCallback(callback);
                }
                return;
            }
        }
        log.info("Asking server peon[%s] to load segment[%s]", new Object[]{this.basePath, segment.getIdentifier()});
        this.queuedSize.addAndGet(segment.getSize());
        this.segmentsToLoad.put(segment, new SegmentHolder(segment, 1, Collections.singletonList(callback)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropSegment(DataSegment segment, LoadPeonCallback callback) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentlyProcessing != null && this.currentlyProcessing.getSegmentIdentifier().equals(segment.getIdentifier())) {
                if (callback != null) {
                    this.currentlyProcessing.addCallback(callback);
                }
                return;
            }
        }
        object = this.lock;
        synchronized (object) {
            SegmentHolder existingHolder = this.segmentsToDrop.get(segment);
            if (existingHolder != null) {
                if (callback != null) {
                    existingHolder.addCallback(callback);
                }
                return;
            }
        }
        log.info("Asking server peon[%s] to drop segment[%s]", new Object[]{this.basePath, segment.getIdentifier()});
        this.segmentsToDrop.put(segment, new SegmentHolder(segment, 0, Collections.singletonList(callback)));
    }

    @Override
    public void markSegmentToDrop(DataSegment dataSegment) {
        this.segmentsMarkedToDrop.add(dataSegment);
    }

    @Override
    public void unmarkSegmentToDrop(DataSegment dataSegment) {
        this.segmentsMarkedToDrop.remove(dataSegment);
    }

    private void processSegmentChangeRequest() {
        if (this.currentlyProcessing != null) {
            log.debug("Server[%s] skipping processSegmentChangeRequest because something is currently loading[%s].", new Object[]{this.basePath, this.currentlyProcessing.getSegmentIdentifier()});
            return;
        }
        if (!this.segmentsToDrop.isEmpty()) {
            this.currentlyProcessing = this.segmentsToDrop.firstEntry().getValue();
            log.info("Server[%s] dropping [%s]", new Object[]{this.basePath, this.currentlyProcessing.getSegmentIdentifier()});
        } else if (!this.segmentsToLoad.isEmpty()) {
            this.currentlyProcessing = this.segmentsToLoad.firstEntry().getValue();
            log.info("Server[%s] loading [%s]", new Object[]{this.basePath, this.currentlyProcessing.getSegmentIdentifier()});
        } else {
            return;
        }
        try {
            if (this.currentlyProcessing == null) {
                if (!this.stopped) {
                    log.makeAlert("Crazy race condition! server[%s]", new Object[]{this.basePath}).emit();
                }
                this.actionCompleted();
                return;
            }
            log.info("Server[%s] processing segment[%s]", new Object[]{this.basePath, this.currentlyProcessing.getSegmentIdentifier()});
            final String path = ZKPaths.makePath((String)this.basePath, (String)this.currentlyProcessing.getSegmentIdentifier());
            byte[] payload = this.jsonMapper.writeValueAsBytes((Object)this.currentlyProcessing.getChangeRequest());
            ((ACLBackgroundPathAndBytesable)this.curator.create().withMode(CreateMode.EPHEMERAL)).forPath(path, payload);
            this.processingExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (CuratorLoadQueuePeon.this.curator.checkExists().forPath(path) != null) {
                            CuratorLoadQueuePeon.this.failAssign((Exception)new ISE("%s was never removed! Failing this operation!", new Object[]{path}));
                        }
                    }
                    catch (Exception e) {
                        CuratorLoadQueuePeon.this.failAssign(e);
                    }
                }
            }, this.config.getLoadTimeoutDelay().getMillis(), TimeUnit.MILLISECONDS);
            Stat stat = (Stat)((BackgroundPathable)this.curator.checkExists().usingWatcher(new CuratorWatcher(){

                public void process(WatchedEvent watchedEvent) throws Exception {
                    switch (watchedEvent.getType()) {
                        case NodeDeleted: {
                            CuratorLoadQueuePeon.this.entryRemoved(watchedEvent.getPath());
                            break;
                        }
                    }
                }
            })).forPath(path);
            if (stat == null) {
                byte[] noopPayload = this.jsonMapper.writeValueAsBytes((Object)new SegmentChangeRequestNoop());
                ((ACLBackgroundPathAndBytesable)this.curator.create().withMode(CreateMode.EPHEMERAL)).forPath(path, noopPayload);
                this.entryRemoved(path);
            }
        }
        catch (Exception e) {
            this.failAssign(e);
        }
    }

    private void actionCompleted() {
        if (this.currentlyProcessing != null) {
            switch (this.currentlyProcessing.getType()) {
                case 1: {
                    this.segmentsToLoad.remove(this.currentlyProcessing.getSegment());
                    this.queuedSize.addAndGet(-this.currentlyProcessing.getSegmentSize());
                    break;
                }
                case 0: {
                    this.segmentsToDrop.remove(this.currentlyProcessing.getSegment());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            final List<LoadPeonCallback> callbacks = this.currentlyProcessing.getCallbacks();
            this.currentlyProcessing = null;
            this.callBackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    CuratorLoadQueuePeon.executeCallbacks(callbacks);
                }
            });
        }
    }

    @Override
    public void start() {
        ScheduledExecutors.scheduleAtFixedRate((ScheduledExecutorService)this.processingExecutor, (Duration)this.config.getLoadQueuePeonRepeatDelay(), (Duration)this.config.getLoadQueuePeonRepeatDelay(), (Callable)new Callable<ScheduledExecutors.Signal>(){

            @Override
            public ScheduledExecutors.Signal call() {
                CuratorLoadQueuePeon.this.processSegmentChangeRequest();
                if (CuratorLoadQueuePeon.this.stopped) {
                    return ScheduledExecutors.Signal.STOP;
                }
                return ScheduledExecutors.Signal.REPEAT;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentlyProcessing != null) {
                CuratorLoadQueuePeon.executeCallbacks(this.currentlyProcessing.getCallbacks());
                this.currentlyProcessing = null;
            }
            if (!this.segmentsToDrop.isEmpty()) {
                for (SegmentHolder holder : this.segmentsToDrop.values()) {
                    CuratorLoadQueuePeon.executeCallbacks(holder.getCallbacks());
                }
            }
            this.segmentsToDrop.clear();
            if (!this.segmentsToLoad.isEmpty()) {
                for (SegmentHolder holder : this.segmentsToLoad.values()) {
                    CuratorLoadQueuePeon.executeCallbacks(holder.getCallbacks());
                }
            }
            this.segmentsToLoad.clear();
            this.queuedSize.set(0L);
            this.failedAssignCount.set(0);
            this.stopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void entryRemoved(String path) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentlyProcessing == null) {
                log.warn("Server[%s] an entry[%s] was removed even though it wasn't loading!?", new Object[]{this.basePath, path});
                return;
            }
            if (!ZKPaths.getNodeFromPath((String)path).equals(this.currentlyProcessing.getSegmentIdentifier())) {
                log.warn("Server[%s] entry [%s] was removed even though it's not what is currently loading[%s]", new Object[]{this.basePath, path, this.currentlyProcessing});
                return;
            }
            this.actionCompleted();
            log.info("Server[%s] done processing [%s]", new Object[]{this.basePath, path});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failAssign(Exception e) {
        Object object = this.lock;
        synchronized (object) {
            log.error((Throwable)e, "Server[%s], throwable caught when submitting [%s].", new Object[]{this.basePath, this.currentlyProcessing});
            this.failedAssignCount.getAndIncrement();
            this.actionCompleted();
        }
    }

    private static class SegmentHolder {
        private final DataSegment segment;
        private final DataSegmentChangeRequest changeRequest;
        private final int type;
        private final List<LoadPeonCallback> callbacks = Lists.newArrayList();

        private SegmentHolder(DataSegment segment, int type, Collection<LoadPeonCallback> callbacks) {
            this.segment = segment;
            this.type = type;
            this.changeRequest = type == 1 ? new SegmentChangeRequestLoad(segment) : new SegmentChangeRequestDrop(segment);
            this.callbacks.addAll(callbacks);
        }

        public DataSegment getSegment() {
            return this.segment;
        }

        public int getType() {
            return this.type;
        }

        public String getSegmentIdentifier() {
            return this.segment.getIdentifier();
        }

        public long getSegmentSize() {
            return this.segment.getSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCallbacks(Collection<LoadPeonCallback> newCallbacks) {
            List<LoadPeonCallback> list = this.callbacks;
            synchronized (list) {
                this.callbacks.addAll(newCallbacks);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCallback(LoadPeonCallback newCallback) {
            List<LoadPeonCallback> list = this.callbacks;
            synchronized (list) {
                this.callbacks.add(newCallback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<LoadPeonCallback> getCallbacks() {
            List<LoadPeonCallback> list = this.callbacks;
            synchronized (list) {
                return this.callbacks;
            }
        }

        public DataSegmentChangeRequest getChangeRequest() {
            return this.changeRequest;
        }

        public String toString() {
            return this.changeRequest.toString();
        }
    }
}

