/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator;

import com.google.common.annotations.VisibleForTesting;
import io.druid.client.ImmutableDruidServer;
import io.druid.java.util.common.IAE;
import io.druid.server.coordinator.ServerHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;

public class DruidCluster {
    private final Set<ServerHolder> realtimes;
    private final Map<String, NavigableSet<ServerHolder>> historicals;

    public DruidCluster() {
        this.realtimes = new HashSet<ServerHolder>();
        this.historicals = new HashMap<String, NavigableSet<ServerHolder>>();
    }

    @VisibleForTesting
    public DruidCluster(@Nullable Set<ServerHolder> realtimes, Map<String, NavigableSet<ServerHolder>> historicals) {
        this.realtimes = realtimes == null ? new HashSet<ServerHolder>() : new HashSet<ServerHolder>(realtimes);
        this.historicals = historicals;
    }

    public void add(ServerHolder serverHolder) {
        switch (serverHolder.getServer().getType()) {
            case HISTORICAL: {
                this.addHistorical(serverHolder);
                break;
            }
            case REALTIME: {
                this.addRealtime(serverHolder);
                break;
            }
            case BRIDGE: {
                this.addHistorical(serverHolder);
                break;
            }
            case INDEXER_EXECUTOR: {
                throw new IAE("unsupported server type[%s]", new Object[]{serverHolder.getServer().getType()});
            }
            default: {
                throw new IAE("unknown server type[%s]", new Object[]{serverHolder.getServer().getType()});
            }
        }
    }

    private void addRealtime(ServerHolder serverHolder) {
        this.realtimes.add(serverHolder);
    }

    private void addHistorical(ServerHolder serverHolder) {
        ImmutableDruidServer server = serverHolder.getServer();
        NavigableSet tierServers = this.historicals.computeIfAbsent(server.getTier(), k -> new TreeSet(Collections.reverseOrder()));
        tierServers.add(serverHolder);
    }

    public Set<ServerHolder> getRealtimes() {
        return this.realtimes;
    }

    public Map<String, NavigableSet<ServerHolder>> getHistoricals() {
        return this.historicals;
    }

    public Iterable<String> getTierNames() {
        return this.historicals.keySet();
    }

    public NavigableSet<ServerHolder> getHistoricalsByTier(String tier) {
        return this.historicals.get(tier);
    }

    public Collection<ServerHolder> getAllServers() {
        int historicalSize = this.historicals.values().stream().mapToInt(Collection::size).sum();
        int realtimeSize = this.realtimes.size();
        ArrayList<ServerHolder> allServers = new ArrayList<ServerHolder>(historicalSize + realtimeSize);
        this.historicals.values().forEach(allServers::addAll);
        allServers.addAll(this.realtimes);
        return allServers;
    }

    public Iterable<NavigableSet<ServerHolder>> getSortedHistoricalsByTier() {
        return this.historicals.values();
    }

    public boolean isEmpty() {
        return this.historicals.isEmpty() && this.realtimes.isEmpty();
    }

    public boolean hasHistoricals() {
        return !this.historicals.isEmpty();
    }

    public boolean hasRealtimes() {
        return !this.realtimes.isEmpty();
    }

    public boolean hasTier(String tier) {
        NavigableSet<ServerHolder> servers = this.historicals.get(tier);
        return servers != null && !servers.isEmpty();
    }
}

