/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import io.druid.client.DruidDataSource;
import io.druid.client.DruidServer;
import io.druid.client.ImmutableDruidDataSource;
import io.druid.client.ImmutableDruidServer;
import io.druid.client.ServerInventoryView;
import io.druid.client.coordinator.Coordinator;
import io.druid.client.indexing.IndexingServiceClient;
import io.druid.common.config.JacksonConfigManager;
import io.druid.curator.discovery.ServiceAnnouncer;
import io.druid.discovery.DruidLeaderSelector;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.CoordinatorIndexingServiceHelper;
import io.druid.guice.annotations.Self;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.Pair;
import io.druid.java.util.common.concurrent.Execs;
import io.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import io.druid.java.util.common.concurrent.ScheduledExecutors;
import io.druid.java.util.common.guava.Comparators;
import io.druid.java.util.common.guava.FunctionalIterable;
import io.druid.java.util.common.lifecycle.LifecycleStart;
import io.druid.java.util.common.lifecycle.LifecycleStop;
import io.druid.java.util.emitter.EmittingLogger;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.metadata.MetadataRuleManager;
import io.druid.metadata.MetadataSegmentManager;
import io.druid.server.DruidNode;
import io.druid.server.coordinator.BalancerStrategy;
import io.druid.server.coordinator.BalancerStrategyFactory;
import io.druid.server.coordinator.CoordinatorDynamicConfig;
import io.druid.server.coordinator.DruidCluster;
import io.druid.server.coordinator.DruidCoordinatorConfig;
import io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import io.druid.server.coordinator.LoadPeonCallback;
import io.druid.server.coordinator.LoadQueuePeon;
import io.druid.server.coordinator.LoadQueueTaskMaster;
import io.druid.server.coordinator.SegmentReplicantLookup;
import io.druid.server.coordinator.ServerHolder;
import io.druid.server.coordinator.helper.DruidCoordinatorBalancer;
import io.druid.server.coordinator.helper.DruidCoordinatorCleanupOvershadowed;
import io.druid.server.coordinator.helper.DruidCoordinatorCleanupUnneeded;
import io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import io.druid.server.coordinator.helper.DruidCoordinatorLogger;
import io.druid.server.coordinator.helper.DruidCoordinatorRuleRunner;
import io.druid.server.coordinator.helper.DruidCoordinatorSegmentInfoLoader;
import io.druid.server.coordinator.rules.LoadRule;
import io.druid.server.coordinator.rules.Rule;
import io.druid.server.initialization.ZkPathsConfig;
import io.druid.server.lookup.cache.LookupCoordinatorManager;
import io.druid.timeline.DataSegment;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.utils.ZKPaths;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;

@ManageLifecycle
public class DruidCoordinator {
    public static Comparator<DataSegment> SEGMENT_COMPARATOR = Ordering.from((Comparator)Comparators.intervalsByEndThenStart()).onResultOf((Function)new Function<DataSegment, Interval>(){

        public Interval apply(DataSegment segment) {
            return segment.getInterval();
        }
    }).compound((Comparator)Ordering.natural()).reverse();
    private static final EmittingLogger log = new EmittingLogger(DruidCoordinator.class);
    private final Object lock = new Object();
    private final DruidCoordinatorConfig config;
    private final ZkPathsConfig zkPaths;
    private final JacksonConfigManager configManager;
    private final MetadataSegmentManager metadataSegmentManager;
    private final ServerInventoryView serverInventoryView;
    private final MetadataRuleManager metadataRuleManager;
    private final CuratorFramework curator;
    private final ServiceEmitter emitter;
    private final IndexingServiceClient indexingServiceClient;
    private final ScheduledExecutorService exec;
    private final LoadQueueTaskMaster taskMaster;
    private final Map<String, LoadQueuePeon> loadManagementPeons;
    private final ServiceAnnouncer serviceAnnouncer;
    private final DruidNode self;
    private final Set<DruidCoordinatorHelper> indexingServiceHelpers;
    private volatile boolean started = false;
    private volatile SegmentReplicantLookup segmentReplicantLookup = null;
    private final BalancerStrategyFactory factory;
    private final LookupCoordinatorManager lookupCoordinatorManager;
    private final DruidLeaderSelector coordLeaderSelector;

    @Inject
    public DruidCoordinator(DruidCoordinatorConfig config, ZkPathsConfig zkPaths, JacksonConfigManager configManager, MetadataSegmentManager metadataSegmentManager, ServerInventoryView serverInventoryView, MetadataRuleManager metadataRuleManager, CuratorFramework curator, ServiceEmitter emitter, ScheduledExecutorFactory scheduledExecutorFactory, IndexingServiceClient indexingServiceClient, LoadQueueTaskMaster taskMaster, ServiceAnnouncer serviceAnnouncer, @Self DruidNode self, @CoordinatorIndexingServiceHelper Set<DruidCoordinatorHelper> indexingServiceHelpers, BalancerStrategyFactory factory, LookupCoordinatorManager lookupCoordinatorManager, @Coordinator DruidLeaderSelector coordLeaderSelector) {
        this(config, zkPaths, configManager, metadataSegmentManager, serverInventoryView, metadataRuleManager, curator, emitter, scheduledExecutorFactory, indexingServiceClient, taskMaster, serviceAnnouncer, self, new ConcurrentHashMap<String, LoadQueuePeon>(), indexingServiceHelpers, factory, lookupCoordinatorManager, coordLeaderSelector);
    }

    DruidCoordinator(DruidCoordinatorConfig config, ZkPathsConfig zkPaths, JacksonConfigManager configManager, MetadataSegmentManager metadataSegmentManager, ServerInventoryView serverInventoryView, MetadataRuleManager metadataRuleManager, CuratorFramework curator, ServiceEmitter emitter, ScheduledExecutorFactory scheduledExecutorFactory, IndexingServiceClient indexingServiceClient, LoadQueueTaskMaster taskMaster, ServiceAnnouncer serviceAnnouncer, DruidNode self, ConcurrentMap<String, LoadQueuePeon> loadQueuePeonMap, Set<DruidCoordinatorHelper> indexingServiceHelpers, BalancerStrategyFactory factory, LookupCoordinatorManager lookupCoordinatorManager, DruidLeaderSelector coordLeaderSelector) {
        this.config = config;
        this.zkPaths = zkPaths;
        this.configManager = configManager;
        this.metadataSegmentManager = metadataSegmentManager;
        this.serverInventoryView = serverInventoryView;
        this.metadataRuleManager = metadataRuleManager;
        this.curator = curator;
        this.emitter = emitter;
        this.indexingServiceClient = indexingServiceClient;
        this.taskMaster = taskMaster;
        this.serviceAnnouncer = serviceAnnouncer;
        this.self = self;
        this.indexingServiceHelpers = indexingServiceHelpers;
        this.exec = scheduledExecutorFactory.create(1, "Coordinator-Exec--%d");
        this.loadManagementPeons = loadQueuePeonMap;
        this.factory = factory;
        this.lookupCoordinatorManager = lookupCoordinatorManager;
        this.coordLeaderSelector = coordLeaderSelector;
    }

    public boolean isLeader() {
        return this.coordLeaderSelector.isLeader();
    }

    public Map<String, LoadQueuePeon> getLoadManagementPeons() {
        return this.loadManagementPeons;
    }

    public Map<String, ? extends Object2LongMap<String>> getReplicationStatus() {
        HashMap retVal = Maps.newHashMap();
        if (this.segmentReplicantLookup == null) {
            return retVal;
        }
        DateTime now = DateTimes.nowUtc();
        for (DataSegment segment : this.getAvailableDataSegments()) {
            List<Rule> rules = this.metadataRuleManager.getRulesWithDefault(segment.getDataSource());
            for (Rule rule : rules) {
                if (!(rule instanceof LoadRule) || !rule.appliesTo(segment, now)) continue;
                ((LoadRule)rule).getTieredReplicants().forEach((tier, ruleReplicants) -> {
                    int currentReplicants = this.segmentReplicantLookup.getLoadedReplicants(segment.getIdentifier(), (String)tier);
                    retVal.computeIfAbsent(tier, ignored -> new Object2LongOpenHashMap()).addTo((Object)segment.getDataSource(), (long)Math.max(ruleReplicants - currentReplicants, 0));
                });
            }
        }
        return retVal;
    }

    public Object2LongMap<String> getSegmentAvailability() {
        Object2LongOpenHashMap retVal = new Object2LongOpenHashMap();
        if (this.segmentReplicantLookup == null) {
            return retVal;
        }
        for (DataSegment segment : this.getAvailableDataSegments()) {
            if (this.segmentReplicantLookup.getLoadedReplicants(segment.getIdentifier()) == 0) {
                retVal.addTo((Object)segment.getDataSource(), 1L);
                continue;
            }
            retVal.addTo((Object)segment.getDataSource(), 0L);
        }
        return retVal;
    }

    boolean hasLoadPending(String dataSource) {
        return this.loadManagementPeons.values().stream().flatMap(peon -> peon.getSegmentsToLoad().stream()).anyMatch(segment -> segment.getDataSource().equals(dataSource));
    }

    public Map<String, Double> getLoadStatus() {
        HashMap loadStatus = Maps.newHashMap();
        for (ImmutableDruidDataSource dataSource : this.metadataSegmentManager.getInventory()) {
            HashSet segments = Sets.newHashSet(dataSource.getSegments());
            int availableSegmentSize = segments.size();
            for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
                DruidDataSource loadedView = druidServer.getDataSource(dataSource.getName());
                if (loadedView == null) continue;
                segments.removeAll(loadedView.getSegments());
            }
            int unloadedSegmentSize = segments.size();
            loadStatus.put(dataSource.getName(), 100.0 * ((double)(availableSegmentSize - unloadedSegmentSize) / (double)availableSegmentSize));
        }
        return loadStatus;
    }

    public CoordinatorDynamicConfig getDynamicConfigs() {
        return (CoordinatorDynamicConfig)this.configManager.watch("coordinator.config", CoordinatorDynamicConfig.class, (Object)new CoordinatorDynamicConfig.Builder().build()).get();
    }

    public void removeSegment(DataSegment segment) {
        log.info("Removing Segment[%s]", new Object[]{segment});
        this.metadataSegmentManager.removeSegment(segment.getDataSource(), segment.getIdentifier());
    }

    public String getCurrentLeader() {
        return this.coordLeaderSelector.getCurrentLeader();
    }

    public void moveSegment(ImmutableDruidServer fromServer, ImmutableDruidServer toServer, DataSegment segment, LoadPeonCallback callback) {
        block12: {
            if (segment == null) {
                log.makeAlert((Throwable)new IAE("Can not move null DataSegment", new Object[0]), "Exception moving null segment", new Object[0]).emit();
                if (callback != null) {
                    callback.execute();
                }
                throw new ISE("Cannot move null DataSegment", new Object[0]);
            }
            String segmentName = segment.getIdentifier();
            try {
                if (fromServer.getMetadata().equals(toServer.getMetadata())) {
                    throw new IAE("Cannot move [%s] to and from the same server [%s]", new Object[]{segmentName, fromServer.getName()});
                }
                ImmutableDruidDataSource dataSource = this.metadataSegmentManager.getInventoryValue(segment.getDataSource());
                if (dataSource == null) {
                    throw new IAE("Unable to find dataSource for segment [%s] in metadata", new Object[]{segmentName});
                }
                DataSegment segmentToLoad = dataSource.getSegment(segment.getIdentifier());
                if (segmentToLoad == null) {
                    throw new IAE("No segment metadata found for segment Id [%s]", new Object[]{segment.getIdentifier()});
                }
                LoadQueuePeon loadPeon = this.loadManagementPeons.get(toServer.getName());
                if (loadPeon == null) {
                    throw new IAE("LoadQueuePeon hasn't been created yet for path [%s]", new Object[]{toServer.getName()});
                }
                LoadQueuePeon dropPeon = this.loadManagementPeons.get(fromServer.getName());
                if (dropPeon == null) {
                    throw new IAE("LoadQueuePeon hasn't been created yet for path [%s]", new Object[]{fromServer.getName()});
                }
                ServerHolder toHolder = new ServerHolder(toServer, loadPeon);
                if (toHolder.getAvailableSize() < segmentToLoad.getSize()) {
                    throw new IAE("Not enough capacity on server [%s] for segment [%s]. Required: %,d, available: %,d.", new Object[]{toServer.getName(), segmentToLoad, segmentToLoad.getSize(), toHolder.getAvailableSize()});
                }
                String toLoadQueueSegPath = ZKPaths.makePath((String)ZKPaths.makePath((String)this.zkPaths.getLoadQueuePath(), (String)toServer.getName()), (String)segmentName);
                LoadPeonCallback loadPeonCallback = () -> {
                    dropPeon.unmarkSegmentToDrop(segmentToLoad);
                    if (callback != null) {
                        callback.execute();
                    }
                };
                dropPeon.markSegmentToDrop(segmentToLoad);
                try {
                    loadPeon.loadSegment(segmentToLoad, () -> {
                        try {
                            if (this.serverInventoryView.isSegmentLoadedByServer(toServer.getName(), segment) && this.curator.checkExists().forPath(toLoadQueueSegPath) == null && !dropPeon.getSegmentsToDrop().contains(segment)) {
                                dropPeon.dropSegment(segment, loadPeonCallback);
                            } else {
                                loadPeonCallback.execute();
                            }
                        }
                        catch (Exception e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                    });
                }
                catch (Exception e) {
                    dropPeon.unmarkSegmentToDrop(segmentToLoad);
                    Throwables.propagate((Throwable)e);
                }
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Exception moving segment %s", new Object[]{segmentName}).emit();
                if (callback == null) break block12;
                callback.execute();
            }
        }
    }

    public Set<DataSegment> getOrderedAvailableDataSegments() {
        TreeSet availableSegments = Sets.newTreeSet(SEGMENT_COMPARATOR);
        List<DataSegment> dataSegments = this.getAvailableDataSegments();
        for (DataSegment dataSegment : dataSegments) {
            if (dataSegment.getSize() < 0L) {
                log.makeAlert("No size on Segment, wtf?", new Object[0]).addData("segment", (Object)dataSegment).emit();
            }
            availableSegments.add(dataSegment);
        }
        return availableSegments;
    }

    private List<DataSegment> getAvailableDataSegments() {
        return this.metadataSegmentManager.getInventory().stream().flatMap(source -> source.getSegments().stream()).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.coordLeaderSelector.registerListener(new DruidLeaderSelector.Listener(){

                @Override
                public void becomeLeader() {
                    DruidCoordinator.this.becomeLeader();
                }

                @Override
                public void stopBeingLeader() {
                    DruidCoordinator.this.stopBeingLeader();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.coordLeaderSelector.unregisterListener();
            this.started = false;
            this.exec.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void becomeLeader() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            log.info("I am the leader of the coordinators, all must bow!", new Object[0]);
            log.info("Starting coordination in [%s]", new Object[]{this.config.getCoordinatorStartDelay()});
            this.metadataSegmentManager.start();
            this.metadataRuleManager.start();
            this.serviceAnnouncer.announce(this.self);
            final int startingLeaderCounter = this.coordLeaderSelector.localTerm();
            ArrayList coordinatorRunnables = Lists.newArrayList();
            coordinatorRunnables.add(Pair.of((Object)new CoordinatorHistoricalManagerRunnable(startingLeaderCounter), (Object)this.config.getCoordinatorPeriod()));
            if (this.indexingServiceClient != null) {
                coordinatorRunnables.add(Pair.of((Object)new CoordinatorIndexingServiceRunnable(this.makeIndexingServiceHelpers(), startingLeaderCounter), (Object)this.config.getCoordinatorIndexingPeriod()));
            }
            for (final Pair coordinatorRunnable : coordinatorRunnables) {
                ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)this.config.getCoordinatorStartDelay(), (Duration)((Duration)coordinatorRunnable.rhs), (Callable)new Callable<ScheduledExecutors.Signal>(){
                    private final CoordinatorRunnable theRunnable;
                    {
                        this.theRunnable = (CoordinatorRunnable)coordinatorRunnable.lhs;
                    }

                    @Override
                    public ScheduledExecutors.Signal call() {
                        if (DruidCoordinator.this.coordLeaderSelector.isLeader() && startingLeaderCounter == DruidCoordinator.this.coordLeaderSelector.localTerm()) {
                            this.theRunnable.run();
                        }
                        if (DruidCoordinator.this.coordLeaderSelector.isLeader() && startingLeaderCounter == DruidCoordinator.this.coordLeaderSelector.localTerm()) {
                            return ScheduledExecutors.Signal.REPEAT;
                        }
                        return ScheduledExecutors.Signal.STOP;
                    }
                });
            }
            this.lookupCoordinatorManager.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBeingLeader() {
        Object object = this.lock;
        synchronized (object) {
            log.info("I am no longer the leader...", new Object[0]);
            for (String server : this.loadManagementPeons.keySet()) {
                LoadQueuePeon peon = this.loadManagementPeons.remove(server);
                peon.stop();
            }
            this.loadManagementPeons.clear();
            this.serviceAnnouncer.unannounce(this.self);
            this.metadataRuleManager.stop();
            this.metadataSegmentManager.stop();
            this.lookupCoordinatorManager.stop();
        }
    }

    private List<DruidCoordinatorHelper> makeIndexingServiceHelpers() {
        ArrayList helpers = Lists.newArrayList();
        helpers.add(new DruidCoordinatorSegmentInfoLoader(this));
        helpers.addAll(this.indexingServiceHelpers);
        log.info("Done making indexing service helpers [%s]", new Object[]{helpers});
        return ImmutableList.copyOf((Collection)helpers);
    }

    private class CoordinatorIndexingServiceRunnable
    extends CoordinatorRunnable {
        public CoordinatorIndexingServiceRunnable(List<DruidCoordinatorHelper> helpers, int startingLeaderCounter) {
            super(helpers, startingLeaderCounter);
        }
    }

    private class CoordinatorHistoricalManagerRunnable
    extends CoordinatorRunnable {
        public CoordinatorHistoricalManagerRunnable(int startingLeaderCounter) {
            super((List<DruidCoordinatorHelper>)ImmutableList.of((Object)new DruidCoordinatorSegmentInfoLoader(DruidCoordinator.this), (Object)new DruidCoordinatorHelper(){

                @Override
                public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
                    FunctionalIterable servers = FunctionalIterable.create(DruidCoordinator.this.serverInventoryView.getInventory()).filter((Predicate)new Predicate<DruidServer>(){

                        public boolean apply(DruidServer input) {
                            return input.segmentReplicatable();
                        }
                    }).transform((Function)new Function<DruidServer, ImmutableDruidServer>(){

                        public ImmutableDruidServer apply(DruidServer input) {
                            return input.toImmutableDruidServer();
                        }
                    });
                    if (log.isDebugEnabled()) {
                        log.debug("Servers", new Object[0]);
                        for (Object druidServer : servers) {
                            log.debug("  %s", new Object[]{druidServer});
                            log.debug("    -- DataSources", new Object[0]);
                            for (ImmutableDruidDataSource druidDataSource : ((ImmutableDruidServer)druidServer).getDataSources()) {
                                log.debug("    %s", new Object[]{druidDataSource});
                            }
                        }
                    }
                    DruidCluster cluster = new DruidCluster();
                    for (ImmutableDruidServer server : servers) {
                        if (!DruidCoordinator.this.loadManagementPeons.containsKey(server.getName())) {
                            LoadQueuePeon loadQueuePeon = DruidCoordinator.this.taskMaster.giveMePeon(server);
                            loadQueuePeon.start();
                            log.info("Created LoadQueuePeon for server[%s].", new Object[]{server.getName()});
                            DruidCoordinator.this.loadManagementPeons.put(server.getName(), loadQueuePeon);
                        }
                        cluster.add(new ServerHolder(server, (LoadQueuePeon)DruidCoordinator.this.loadManagementPeons.get(server.getName())));
                    }
                    DruidCoordinator.this.segmentReplicantLookup = SegmentReplicantLookup.make(cluster);
                    HashSet disappeared = Sets.newHashSet(DruidCoordinator.this.loadManagementPeons.keySet());
                    for (ImmutableDruidServer server : servers) {
                        disappeared.remove(server.getName());
                    }
                    for (String name : disappeared) {
                        log.info("Removing listener for server[%s] which is no longer there.", new Object[]{name});
                        LoadQueuePeon peon = (LoadQueuePeon)DruidCoordinator.this.loadManagementPeons.remove(name);
                        peon.stop();
                    }
                    return params.buildFromExisting().withDruidCluster(cluster).withDatabaseRuleManager(DruidCoordinator.this.metadataRuleManager).withLoadManagementPeons(DruidCoordinator.this.loadManagementPeons).withSegmentReplicantLookup(DruidCoordinator.this.segmentReplicantLookup).withBalancerReferenceTimestamp(DateTimes.nowUtc()).build();
                }
            }, (Object)new DruidCoordinatorRuleRunner(DruidCoordinator.this), (Object)new DruidCoordinatorCleanupUnneeded(DruidCoordinator.this), (Object)new DruidCoordinatorCleanupOvershadowed(DruidCoordinator.this), (Object)new DruidCoordinatorBalancer(DruidCoordinator.this), (Object)new DruidCoordinatorLogger(DruidCoordinator.this)), startingLeaderCounter);
        }
    }

    public abstract class CoordinatorRunnable
    implements Runnable {
        private final long startTime = System.currentTimeMillis();
        private final List<DruidCoordinatorHelper> helpers;
        private final int startingLeaderCounter;

        protected CoordinatorRunnable(List<DruidCoordinatorHelper> helpers, int startingLeaderCounter) {
            this.helpers = helpers;
            this.startingLeaderCounter = startingLeaderCounter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ListeningExecutorService balancerExec = null;
            try {
                Object object = DruidCoordinator.this.lock;
                synchronized (object) {
                    if (!DruidCoordinator.this.coordLeaderSelector.isLeader()) {
                        log.info("LEGGO MY EGGO. [%s] is leader.", new Object[]{DruidCoordinator.this.coordLeaderSelector.getCurrentLeader()});
                        DruidCoordinator.this.stopBeingLeader();
                        return;
                    }
                }
                List<Boolean> allStarted = Arrays.asList(DruidCoordinator.this.metadataSegmentManager.isStarted(), DruidCoordinator.this.serverInventoryView.isStarted());
                for (Boolean aBoolean : allStarted) {
                    if (aBoolean.booleanValue()) continue;
                    log.error("InventoryManagers not started[%s]", new Object[]{allStarted});
                    DruidCoordinator.this.stopBeingLeader();
                    return;
                }
                balancerExec = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)DruidCoordinator.this.getDynamicConfigs().getBalancerComputeThreads(), (String)"coordinator-cost-balancer-%s"));
                BalancerStrategy balancerStrategy = DruidCoordinator.this.factory.createBalancerStrategy(balancerExec);
                DruidCoordinatorRuntimeParams params = DruidCoordinatorRuntimeParams.newBuilder().withStartTime(this.startTime).withDatasources(DruidCoordinator.this.metadataSegmentManager.getInventory()).withDynamicConfigs(DruidCoordinator.this.getDynamicConfigs()).withEmitter(DruidCoordinator.this.emitter).withBalancerStrategy(balancerStrategy).build();
                Iterator<DruidCoordinatorHelper> iterator = this.helpers.iterator();
                while (iterator.hasNext()) {
                    DruidCoordinatorHelper helper = iterator.next();
                    if (!DruidCoordinator.this.coordLeaderSelector.isLeader() || this.startingLeaderCounter != DruidCoordinator.this.coordLeaderSelector.localTerm()) continue;
                    params = helper.run(params);
                }
                return;
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Caught exception, ignoring so that schedule keeps going.", new Object[0]).emit();
                return;
            }
            finally {
                if (balancerExec != null) {
                    balancerExec.shutdownNow();
                }
            }
        }
    }
}

