/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.druid.client.ImmutableDruidDataSource;
import io.druid.client.indexing.IndexingServiceClient;
import io.druid.indexer.TaskStatusPlus;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.guava.Comparators;
import io.druid.java.util.common.logger.Logger;
import io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import java.util.ArrayList;
import java.util.Comparator;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class DruidCoordinatorCleanupPendingSegments
implements DruidCoordinatorHelper {
    private static final Logger log = new Logger(DruidCoordinatorCleanupPendingSegments.class);
    private static final Period KEEP_PENDING_SEGMENTS_OFFSET = new Period((Object)"P1D");
    private final IndexingServiceClient indexingServiceClient;

    @Inject
    public DruidCoordinatorCleanupPendingSegments(IndexingServiceClient indexingServiceClient) {
        this.indexingServiceClient = indexingServiceClient;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        ArrayList<DateTime> createdTimes = new ArrayList<DateTime>();
        createdTimes.add(this.indexingServiceClient.getRunningTasks().stream().map(TaskStatusPlus::getCreatedTime).min((Comparator<DateTime>)Comparators.naturalNullsFirst()).orElse(DateTimes.nowUtc()));
        createdTimes.add(this.indexingServiceClient.getPendingTasks().stream().map(TaskStatusPlus::getCreatedTime).min((Comparator<DateTime>)Comparators.naturalNullsFirst()).orElse(DateTimes.nowUtc()));
        createdTimes.add(this.indexingServiceClient.getWaitingTasks().stream().map(TaskStatusPlus::getCreatedTime).min((Comparator<DateTime>)Comparators.naturalNullsFirst()).orElse(DateTimes.nowUtc()));
        TaskStatusPlus completeTaskStatus = this.indexingServiceClient.getLastCompleteTask();
        if (completeTaskStatus != null) {
            createdTimes.add(completeTaskStatus.getCreatedTime());
        }
        createdTimes.sort((Comparator<DateTime>)Comparators.naturalNullsFirst());
        Preconditions.checkState((!createdTimes.isEmpty() ? 1 : 0) != 0, (Object)"Failed to gather createdTimes of tasks");
        DateTime pendingSegmentsCleanupEndTime = ((DateTime)createdTimes.get(0)).minus((ReadablePeriod)KEEP_PENDING_SEGMENTS_OFFSET);
        for (ImmutableDruidDataSource dataSource : params.getDataSources()) {
            if (params.getCoordinatorDynamicConfig().getKillPendingSegmentsSkipList().contains(dataSource.getName())) continue;
            log.info("Killed [%d] pendingSegments created until [%s] for dataSource[%s]", new Object[]{this.indexingServiceClient.killPendingSegments(dataSource.getName(), pendingSegmentsCleanupEndTime), pendingSegmentsCleanupEndTime, dataSource});
        }
        return params;
    }
}

