/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator.helper;

import com.google.common.collect.Lists;
import io.druid.client.ImmutableDruidServer;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.emitter.EmittingLogger;
import io.druid.server.coordinator.BalancerSegmentHolder;
import io.druid.server.coordinator.BalancerStrategy;
import io.druid.server.coordinator.CoordinatorStats;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import io.druid.server.coordinator.LoadPeonCallback;
import io.druid.server.coordinator.LoadQueuePeon;
import io.druid.server.coordinator.ServerHolder;
import io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import io.druid.timeline.DataSegment;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;

public class DruidCoordinatorBalancer
implements DruidCoordinatorHelper {
    public static final Comparator<ServerHolder> percentUsedComparator = Comparator.comparing(ServerHolder::getPercentUsed).reversed();
    protected static final EmittingLogger log = new EmittingLogger(DruidCoordinatorBalancer.class);
    protected final DruidCoordinator coordinator;
    protected final Map<String, ConcurrentHashMap<String, BalancerSegmentHolder>> currentlyMovingSegments = new HashMap<String, ConcurrentHashMap<String, BalancerSegmentHolder>>();

    public DruidCoordinatorBalancer(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    protected void reduceLifetimes(String tier) {
        for (BalancerSegmentHolder holder : this.currentlyMovingSegments.get(tier).values()) {
            holder.reduceLifetime();
            if (holder.getLifetime() > 0) continue;
            log.makeAlert("[%s]: Balancer move segments queue has a segment stuck", new Object[]{tier}).addData("segment", (Object)holder.getSegment().getIdentifier()).addData("server", (Object)holder.getFromServer().getMetadata()).emit();
        }
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        CoordinatorStats stats = new CoordinatorStats();
        params.getDruidCluster().getHistoricals().forEach((tier, servers) -> this.balanceTier(params, (String)tier, (SortedSet<ServerHolder>)servers, stats));
        return params.buildFromExisting().withCoordinatorStats(stats).build();
    }

    private void balanceTier(DruidCoordinatorRuntimeParams params, String tier, SortedSet<ServerHolder> servers, CoordinatorStats stats) {
        BalancerStrategy strategy = params.getBalancerStrategy();
        int maxSegmentsToMove = params.getCoordinatorDynamicConfig().getMaxSegmentsToMove();
        this.currentlyMovingSegments.computeIfAbsent(tier, t -> new ConcurrentHashMap());
        if (!this.currentlyMovingSegments.get(tier).isEmpty()) {
            this.reduceLifetimes(tier);
            log.info("[%s]: Still waiting on %,d segments to be moved", new Object[]{tier, this.currentlyMovingSegments.get(tier).size()});
            return;
        }
        ArrayList serverHolderList = Lists.newArrayList(servers);
        if (serverHolderList.size() <= 1) {
            log.info("[%s]: One or fewer servers found.  Cannot balance.", new Object[]{tier});
            return;
        }
        int numSegments = 0;
        for (ServerHolder server : serverHolderList) {
            numSegments += server.getServer().getSegments().size();
        }
        if (numSegments == 0) {
            log.info("No segments found.  Cannot balance.", new Object[0]);
            return;
        }
        long unmoved = 0L;
        for (int iter = 0; iter < maxSegmentsToMove; ++iter) {
            BalancerSegmentHolder segmentToMove = strategy.pickSegmentToMove(serverHolderList);
            if (segmentToMove == null || !params.getAvailableSegments().contains(segmentToMove.getSegment())) continue;
            ServerHolder holder = strategy.findNewSegmentHomeBalancer(segmentToMove.getSegment(), serverHolderList);
            if (holder != null) {
                this.moveSegment(segmentToMove, holder.getServer(), params);
                continue;
            }
            ++unmoved;
        }
        if (unmoved == (long)maxSegmentsToMove) {
            log.info("No good moves found in tier [%s]", new Object[]{tier});
        }
        stats.addToTieredStat("unmovedCount", tier, unmoved);
        stats.addToTieredStat("movedCount", tier, this.currentlyMovingSegments.get(tier).size());
        if (params.getCoordinatorDynamicConfig().emitBalancingStats()) {
            strategy.emitStats(tier, stats, serverHolderList);
        }
        log.info("[%s]: Segments Moved: [%d] Segments Let Alone: [%d]", new Object[]{tier, this.currentlyMovingSegments.get(tier).size(), unmoved});
    }

    protected void moveSegment(BalancerSegmentHolder segment, ImmutableDruidServer toServer, DruidCoordinatorRuntimeParams params) {
        block3: {
            LoadQueuePeon toPeon = params.getLoadManagementPeons().get(toServer.getName());
            ImmutableDruidServer fromServer = segment.getFromServer();
            DataSegment segmentToMove = segment.getSegment();
            String segmentName = segmentToMove.getIdentifier();
            if (!toPeon.getSegmentsToLoad().contains(segmentToMove) && toServer.getSegment(segmentName) == null && new ServerHolder(toServer, toPeon).getAvailableSize() > segmentToMove.getSize()) {
                log.info("Moving [%s] from [%s] to [%s]", new Object[]{segmentName, fromServer.getName(), toServer.getName()});
                LoadPeonCallback callback = null;
                try {
                    Map movingSegments = this.currentlyMovingSegments.get(toServer.getTier());
                    movingSegments.put(segmentName, segment);
                    callback = () -> {
                        BalancerSegmentHolder cfr_ignored_0 = (BalancerSegmentHolder)movingSegments.remove(segmentName);
                    };
                    this.coordinator.moveSegment(fromServer, toServer, segmentToMove, callback);
                }
                catch (Exception e) {
                    log.makeAlert((Throwable)e, StringUtils.format((String)"[%s] : Moving exception", (Object[])new Object[]{segmentName}), new Object[0]).emit();
                    if (callback == null) break block3;
                    callback.execute();
                }
            }
        }
    }
}

