/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator.helper;

import com.google.common.collect.Maps;
import io.druid.client.ImmutableDruidDataSource;
import io.druid.client.ImmutableDruidServer;
import io.druid.java.util.common.guava.Comparators;
import io.druid.server.coordinator.CoordinatorStats;
import io.druid.server.coordinator.DruidCluster;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import io.druid.server.coordinator.ServerHolder;
import io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import io.druid.timeline.DataSegment;
import io.druid.timeline.VersionedIntervalTimeline;
import java.util.HashMap;
import java.util.SortedSet;

public class DruidCoordinatorCleanupOvershadowed
implements DruidCoordinatorHelper {
    private final DruidCoordinator coordinator;

    public DruidCoordinatorCleanupOvershadowed(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        CoordinatorStats stats = new CoordinatorStats();
        if (params.hasDeletionWaitTimeElapsed()) {
            DruidCluster cluster = params.getDruidCluster();
            HashMap timelines = Maps.newHashMap();
            for (SortedSet sortedSet : cluster.getSortedHistoricalsByTier()) {
                for (ServerHolder serverHolder : sortedSet) {
                    ImmutableDruidServer server = serverHolder.getServer();
                    for (ImmutableDruidDataSource dataSource : server.getDataSources()) {
                        VersionedIntervalTimeline timeline = (VersionedIntervalTimeline)timelines.get(dataSource.getName());
                        if (timeline == null) {
                            timeline = new VersionedIntervalTimeline(Comparators.comparable());
                            timelines.put(dataSource.getName(), timeline);
                        }
                        for (DataSegment segment : dataSource.getSegments()) {
                            timeline.add(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)segment));
                        }
                    }
                }
            }
            for (DataSegment dataSegment : params.getAvailableSegments()) {
                VersionedIntervalTimeline timeline = (VersionedIntervalTimeline)timelines.get(dataSegment.getDataSource());
                if (timeline == null || !timeline.isOvershadowed(dataSegment.getInterval(), (Object)dataSegment.getVersion())) continue;
                this.coordinator.removeSegment(dataSegment);
                stats.addToGlobalStat("overShadowedCount", 1L);
            }
        }
        return params.buildFromExisting().withCoordinatorStats(stats).build();
    }
}

