/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator.helper;

import io.druid.client.ImmutableDruidDataSource;
import io.druid.client.ImmutableDruidServer;
import io.druid.java.util.common.logger.Logger;
import io.druid.server.coordinator.CoordinatorStats;
import io.druid.server.coordinator.DruidCluster;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import io.druid.server.coordinator.LoadPeonCallback;
import io.druid.server.coordinator.LoadQueuePeon;
import io.druid.server.coordinator.ServerHolder;
import io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import io.druid.timeline.DataSegment;
import java.util.Set;
import java.util.SortedSet;

public class DruidCoordinatorCleanupUnneeded
implements DruidCoordinatorHelper {
    private static final Logger log = new Logger(DruidCoordinatorCleanupUnneeded.class);
    private final DruidCoordinator coordinator;

    public DruidCoordinatorCleanupUnneeded(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        CoordinatorStats stats = new CoordinatorStats();
        Set<DataSegment> availableSegments = params.getAvailableSegments();
        DruidCluster cluster = params.getDruidCluster();
        if (!availableSegments.isEmpty()) {
            for (SortedSet sortedSet : cluster.getSortedHistoricalsByTier()) {
                for (ServerHolder serverHolder : sortedSet) {
                    ImmutableDruidServer server = serverHolder.getServer();
                    for (ImmutableDruidDataSource dataSource : server.getDataSources()) {
                        for (DataSegment segment : dataSource.getSegments()) {
                            LoadQueuePeon queuePeon;
                            if (availableSegments.contains(segment) || (queuePeon = params.getLoadManagementPeons().get(server.getName())).getSegmentsToDrop().contains(segment)) continue;
                            queuePeon.dropSegment(segment, new LoadPeonCallback(){

                                @Override
                                public void execute() {
                                }
                            });
                            stats.addToTieredStat("unneededCount", server.getTier(), 1L);
                        }
                    }
                }
            }
        } else {
            log.info("Found 0 availableSegments, skipping the cleanup of segments from historicals. This is done to prevent a race condition in which the coordinator would drop all segments if it started running cleanup before it finished polling the metadata storage for available segments for the first time.", new Object[0]);
        }
        return params.buildFromExisting().withCoordinatorStats(stats).build();
    }
}

