/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator.helper;

import io.druid.java.util.common.logger.Logger;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import io.druid.timeline.DataSegment;
import java.util.Set;

public class DruidCoordinatorSegmentInfoLoader
implements DruidCoordinatorHelper {
    private final DruidCoordinator coordinator;
    private static final Logger log = new Logger(DruidCoordinatorSegmentInfoLoader.class);

    public DruidCoordinatorSegmentInfoLoader(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        log.info("Starting coordination. Getting available segments.", new Object[0]);
        Set<DataSegment> availableSegments = this.coordinator.getOrderedAvailableDataSegments();
        if (log.isDebugEnabled()) {
            log.debug("Available DataSegments", new Object[0]);
            for (DataSegment dataSegment : availableSegments) {
                log.debug("  %s", new Object[]{dataSegment});
            }
        }
        log.info("Found [%,d] available segments.", new Object[]{availableSegments.size()});
        return params.buildFromExisting().withAvailableSegments(availableSegments).build();
    }
}

