/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator.rules;

import io.druid.java.util.emitter.EmittingLogger;
import io.druid.server.coordinator.CoordinatorStats;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import io.druid.server.coordinator.ServerHolder;
import io.druid.server.coordinator.rules.Rule;
import io.druid.timeline.DataSegment;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class BroadcastDistributionRule
implements Rule {
    private static final EmittingLogger log = new EmittingLogger(BroadcastDistributionRule.class);

    @Override
    public CoordinatorStats run(DruidCoordinator coordinator, DruidCoordinatorRuntimeParams params, DataSegment segment) {
        HashSet<ServerHolder> loadServerHolders = new HashSet<ServerHolder>();
        HashSet<ServerHolder> dropServerHolders = new HashSet<ServerHolder>();
        List<String> colocatedDataSources = this.getColocatedDataSources();
        if (colocatedDataSources == null || colocatedDataSources.isEmpty()) {
            loadServerHolders.addAll(params.getDruidCluster().getAllServers());
        } else {
            params.getDruidCluster().getAllServers().forEach(eachHolder -> {
                if (colocatedDataSources.stream().anyMatch(source -> eachHolder.getServer().getDataSource((String)source) != null)) {
                    loadServerHolders.add((ServerHolder)eachHolder);
                } else if (eachHolder.isServingSegment(segment) && !eachHolder.getPeon().getSegmentsToDrop().contains(segment)) {
                    dropServerHolders.add((ServerHolder)eachHolder);
                }
            });
        }
        CoordinatorStats stats = new CoordinatorStats();
        return stats.accumulate(this.assign(loadServerHolders, segment)).accumulate(this.drop(dropServerHolders, segment));
    }

    private CoordinatorStats assign(Set<ServerHolder> serverHolders, DataSegment segment) {
        CoordinatorStats stats = new CoordinatorStats();
        stats.addToGlobalStat("assignedCount", 0L);
        for (ServerHolder holder : serverHolders) {
            if (segment.getSize() > holder.getAvailableSize()) {
                log.makeAlert("Failed to broadcast segment for [%s]", new Object[]{segment.getDataSource()}).addData("segmentId", (Object)segment.getIdentifier()).addData("segmentSize", (Object)segment.getSize()).addData("hostName", (Object)holder.getServer().getHost()).addData("availableSize", (Object)holder.getAvailableSize()).emit();
                continue;
            }
            if (holder.isLoadingSegment(segment)) continue;
            holder.getPeon().loadSegment(segment, null);
            stats.addToGlobalStat("assignedCount", 1L);
        }
        return stats;
    }

    private CoordinatorStats drop(Set<ServerHolder> serverHolders, DataSegment segment) {
        CoordinatorStats stats = new CoordinatorStats();
        for (ServerHolder holder : serverHolders) {
            holder.getPeon().dropSegment(segment, null);
            stats.addToGlobalStat("droppedCount", 1L);
        }
        return stats;
    }

    public abstract List<String> getColocatedDataSources();
}

