/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.emitter;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.druid.java.util.emitter.core.Emitter;
import io.druid.java.util.emitter.core.HttpPostEmitter;
import io.druid.java.util.emitter.core.ParametrizedUriEmitter;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.java.util.metrics.AbstractMonitor;
import io.druid.java.util.metrics.HttpPostEmitterMonitor;
import io.druid.java.util.metrics.ParametrizedUriEmitterMonitor;

public class HttpEmittingMonitor
extends AbstractMonitor {
    private AbstractMonitor delegate;

    @Inject
    public HttpEmittingMonitor(Emitter emitter) {
        if (emitter instanceof HttpPostEmitter) {
            this.delegate = new HttpPostEmitterMonitor("metrics", (HttpPostEmitter)emitter, ImmutableMap.of());
        } else if (emitter instanceof ParametrizedUriEmitter) {
            this.delegate = new ParametrizedUriEmitterMonitor("metrics", (ParametrizedUriEmitter)emitter);
        } else {
            throw new IllegalStateException("Unable to use HttpEmittingMonitor with emitter other than HttpPostEmitter or ParametrizedUriEmitter, " + emitter.getClass() + " is used");
        }
    }

    public boolean doMonitor(ServiceEmitter serviceEmitter) {
        return this.delegate.doMonitor(serviceEmitter);
    }
}

