/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.druid.client.indexing.IndexingService;
import io.druid.discovery.DruidLeaderClient;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.proxy.ProxyServlet;

public class OverlordProxyServlet
extends ProxyServlet {
    private final DruidLeaderClient druidLeaderClient;

    @Inject
    OverlordProxyServlet(@IndexingService DruidLeaderClient druidLeaderClient) {
        this.druidLeaderClient = druidLeaderClient;
    }

    protected String rewriteTarget(HttpServletRequest request) {
        try {
            String overlordLeader = this.druidLeaderClient.findCurrentLeader();
            if (overlordLeader == null) {
                throw new ISE("Can't find Overlord leader.", new Object[0]);
            }
            String location = StringUtils.format((String)"%s%s", (Object[])new Object[]{overlordLeader, request.getRequestURI()});
            if (request.getQueryString() != null) {
                location = StringUtils.format((String)"%s?%s", (Object[])new Object[]{location, request.getQueryString()});
            }
            return new URI(location).toString();
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected void sendProxyRequest(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Request proxyRequest) {
        clientRequest.setAttribute("Druid-Authorization-Checked", (Object)true);
        super.sendProxyRequest(clientRequest, proxyResponse, proxyRequest);
    }
}

