/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.listener.announcer;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.druid.server.initialization.ZkPathsConfig;
import org.apache.curator.utils.ZKPaths;

public class ListeningAnnouncerConfig {
    @JacksonInject
    private final ZkPathsConfig zkPathsConfig;
    @JsonProperty(value="listenersPath")
    private String listenersPath = null;

    @Inject
    public ListeningAnnouncerConfig(ZkPathsConfig zkPathsConfig) {
        this.zkPathsConfig = zkPathsConfig;
    }

    @JsonProperty(value="listenersPath")
    public String getListenersPath() {
        return this.listenersPath == null ? this.zkPathsConfig.defaultPath("listeners") : this.listenersPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListeningAnnouncerConfig that = (ListeningAnnouncerConfig)o;
        return !(this.listenersPath == null ? that.listenersPath != null : !this.listenersPath.equals(that.listenersPath));
    }

    public int hashCode() {
        return this.listenersPath != null ? this.listenersPath.hashCode() : 0;
    }

    public String toString() {
        return "ListeningAnnouncerConfig{listenersPath='" + this.getListenersPath() + '\'' + '}';
    }

    public String getAnnouncementPath(String listenerName) {
        return ZKPaths.makePath((String)this.getListenersPath(), (String)((String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)listenerName), (Object)"Listener name cannot be null")));
    }
}

