/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.log;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.druid.java.util.common.logger.Logger;
import io.druid.server.RequestLogLine;
import io.druid.server.log.RequestLogger;
import io.druid.server.log.RequestLoggerProvider;
import java.io.IOException;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="filtered")
public class FilteredRequestLoggerProvider
implements RequestLoggerProvider {
    private static final Logger log = new Logger(FilteredRequestLoggerProvider.class);
    @JsonProperty
    @NotNull
    private RequestLoggerProvider delegate = null;
    @JsonProperty
    private long queryTimeThresholdMs = 0L;

    public RequestLogger get() {
        FilteredRequestLogger logger = new FilteredRequestLogger((RequestLogger)this.delegate.get(), this.queryTimeThresholdMs);
        log.debug((Throwable)new Exception("Stack trace"), "Creating %s at", new Object[]{logger});
        return logger;
    }

    public static class FilteredRequestLogger
    implements RequestLogger {
        private final long queryTimeThresholdMs;
        private final RequestLogger logger;

        public FilteredRequestLogger(RequestLogger logger, long queryTimeThresholdMs) {
            this.logger = logger;
            this.queryTimeThresholdMs = queryTimeThresholdMs;
        }

        @Override
        public void log(RequestLogLine requestLogLine) throws IOException {
            Object queryTime = requestLogLine.getQueryStats().getStats().get("query/time");
            if (queryTime != null && ((Number)queryTime).longValue() >= this.queryTimeThresholdMs) {
                this.logger.log(requestLogLine);
            }
        }

        public String toString() {
            return "FilteredRequestLogger{queryTimeThresholdMs=" + this.queryTimeThresholdMs + ", logger=" + this.logger + '}';
        }
    }
}

