/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.metrics;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.druid.java.util.common.logger.Logger;
import io.druid.java.util.metrics.Monitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.validation.constraints.NotNull;

public class MonitorsConfig {
    private static final Logger log = new Logger(MonitorsConfig.class);
    public static final String METRIC_DIMENSION_PREFIX = "druid.metrics.emitter.dimension.";
    public static final String OLD_METAMX_PACKAGE_NAME = "com.metamx.metrics";
    public static final String NEW_DRUID_PACKAGE_NAME = "io.druid.java.util.metrics";
    @JsonProperty(value="monitors")
    @NotNull
    private List<Class<? extends Monitor>> monitors;

    public List<Class<? extends Monitor>> getMonitors() {
        return this.monitors;
    }

    public MonitorsConfig(@JsonProperty(value="monitors") List<String> monitorNames) {
        this.monitors = MonitorsConfig.getMonitorsFromNames(monitorNames);
    }

    public String toString() {
        return "MonitorsConfig{monitors=" + this.monitors + '}';
    }

    public static Map<String, String[]> mapOfDatasourceAndTaskID(String datasource, String taskId) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (datasource != null) {
            builder.put((Object)"dataSource", (Object)new String[]{datasource});
        }
        if (taskId != null) {
            builder.put((Object)"id", (Object)new String[]{taskId});
        }
        return builder.build();
    }

    public static Map<String, String[]> extractDimensions(Properties props, List<String> dimensions) {
        HashMap<String, String[]> dimensionsMap = new HashMap<String, String[]>();
        for (String property : props.stringPropertyNames()) {
            String dimension;
            if (!property.startsWith(METRIC_DIMENSION_PREFIX) || !dimensions.contains(dimension = property.substring(METRIC_DIMENSION_PREFIX.length()))) continue;
            dimensionsMap.put(dimension, new String[]{props.getProperty(property)});
        }
        return dimensionsMap;
    }

    private static List<Class<? extends Monitor>> getMonitorsFromNames(List<String> monitorNames) {
        ArrayList monitors = Lists.newArrayList();
        if (monitorNames == null) {
            return monitors;
        }
        try {
            for (String monitorName : monitorNames) {
                String effectiveMonitorName = monitorName.replace(OLD_METAMX_PACKAGE_NAME, NEW_DRUID_PACKAGE_NAME);
                if (!effectiveMonitorName.equals(monitorName)) {
                    log.warn("Deprecated Monitor class name [%s] found, please use package %s instead of %s", new Object[]{monitorName, NEW_DRUID_PACKAGE_NAME, OLD_METAMX_PACKAGE_NAME});
                }
                Class<?> monitorClass = Class.forName(effectiveMonitorName);
                monitors.add(monitorClass);
            }
            return monitors;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }
}

