/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.metrics;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.java.util.emitter.service.ServiceMetricEvent;
import io.druid.java.util.metrics.AbstractMonitor;
import io.druid.java.util.metrics.KeyedDiff;
import io.druid.server.metrics.QueryCountStatsProvider;
import java.util.Map;

public class QueryCountStatsMonitor
extends AbstractMonitor {
    private final KeyedDiff keyedDiff = new KeyedDiff();
    private final QueryCountStatsProvider statsProvider;

    @Inject
    public QueryCountStatsMonitor(QueryCountStatsProvider statsProvider) {
        this.statsProvider = statsProvider;
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
        Map diff = this.keyedDiff.to("queryCountStats", (Map)ImmutableMap.of((Object)"query/success/count", (Object)this.statsProvider.getSuccessfulQueryCount(), (Object)"query/failed/count", (Object)this.statsProvider.getFailedQueryCount(), (Object)"query/interrupted/count", (Object)this.statsProvider.getInterruptedQueryCount()));
        if (diff != null) {
            for (Map.Entry diffEntry : diff.entrySet()) {
                emitter.emit(builder.build((String)diffEntry.getKey(), (Number)diffEntry.getValue()));
            }
        }
        return true;
    }
}

