/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.router;

import io.druid.client.selector.Server;
import io.druid.java.util.common.StringUtils;
import io.druid.server.router.AvaticaConnectionBalancer;
import io.druid.server.router.ConsistentHasher;
import java.util.Collection;
import java.util.HashMap;

public class ConsistentHashAvaticaConnectionBalancer
implements AvaticaConnectionBalancer {
    private final ConsistentHasher hasher = new ConsistentHasher(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Server pickServer(Collection<Server> servers, String connectionId) {
        ConsistentHasher consistentHasher = this.hasher;
        synchronized (consistentHasher) {
            if (servers.isEmpty()) {
                return null;
            }
            HashMap<String, Server> serverMap = new HashMap<String, Server>();
            for (Server server : servers) {
                serverMap.put(server.getHost(), server);
            }
            this.hasher.updateKeys(serverMap.keySet());
            String chosenServer = this.hasher.findKey(StringUtils.toUtf8((String)connectionId));
            return (Server)serverMap.get(chosenServer);
        }
    }
}

