/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class AuthConfig {
    public static final String DRUID_AUTHENTICATION_RESULT = "Druid-Authentication-Result";
    public static final String DRUID_AUTHORIZATION_CHECKED = "Druid-Authorization-Checked";
    public static final String ALLOW_ALL_NAME = "allowAll";
    @JsonProperty
    private final List<String> authenticatorChain;
    @JsonProperty
    private List<String> authorizers;

    public AuthConfig() {
        this(null, null);
    }

    @JsonCreator
    public AuthConfig(@JsonProperty(value="authenticatorChain") List<String> authenticationChain, @JsonProperty(value="authorizers") List<String> authorizers) {
        this.authenticatorChain = authenticationChain;
        this.authorizers = authorizers;
    }

    public List<String> getAuthenticatorChain() {
        return this.authenticatorChain;
    }

    public List<String> getAuthorizers() {
        return this.authorizers;
    }

    public String toString() {
        return "AuthConfig{authenticatorChain='" + this.authenticatorChain + '\'' + ", authorizers='" + this.authorizers + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthConfig that = (AuthConfig)o;
        if (this.getAuthenticatorChain() != null ? !this.getAuthenticatorChain().equals(that.getAuthenticatorChain()) : that.getAuthenticatorChain() != null) {
            return false;
        }
        return this.getAuthorizers() != null ? this.getAuthorizers().equals(that.getAuthorizers()) : that.getAuthorizers() == null;
    }

    public int hashCode() {
        int result = this.getAuthenticatorChain() != null ? this.getAuthenticatorChain().hashCode() : 0;
        result = 31 * result + (this.getAuthorizers() != null ? this.getAuthorizers().hashCode() : 0);
        return result;
    }
}

