/*
 * Decompiled with CFR 0.152.
 */
package io.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import io.druid.data.input.InputRow;
import io.druid.timeline.partition.LinearPartitionChunk;
import io.druid.timeline.partition.PartitionChunk;
import io.druid.timeline.partition.ShardSpec;
import io.druid.timeline.partition.ShardSpecLookup;
import java.util.List;
import java.util.Map;

public class LinearShardSpec
implements ShardSpec {
    private int partitionNum;

    @JsonCreator
    public LinearShardSpec(@JsonProperty(value="partitionNum") Integer partitionNum) {
        this.partitionNum = (Integer)Preconditions.checkNotNull((Object)partitionNum, (Object)"Must set partitionNum on LinearShardSpec");
    }

    @JsonProperty(value="partitionNum")
    public int getPartitionNum() {
        return this.partitionNum;
    }

    public ShardSpecLookup getLookup(final List<ShardSpec> shardSpecs) {
        return new ShardSpecLookup(){

            public ShardSpec getShardSpec(long timestamp, InputRow row) {
                return (ShardSpec)shardSpecs.get(0);
            }
        };
    }

    public Map<String, Range<String>> getDomain() {
        return ImmutableMap.of();
    }

    public <T> PartitionChunk<T> createChunk(T obj) {
        return new LinearPartitionChunk(this.partitionNum, obj);
    }

    public boolean isInChunk(long timestamp, InputRow inputRow) {
        return true;
    }

    public String toString() {
        return "LinearShardSpec{partitionNum=" + this.partitionNum + '}';
    }
}

