/*
 * Decompiled with CFR 0.152.
 */
package io.druid.storage.hdfs;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.io.ByteSource;
import com.google.inject.Inject;
import io.druid.java.util.common.CompressionUtils;
import io.druid.java.util.common.FileUtils;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.RetryUtils;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.UOE;
import io.druid.java.util.common.logger.Logger;
import io.druid.segment.loading.DataSegmentPuller;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.segment.loading.URIDataPuller;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.concurrent.Callable;
import javax.tools.FileObject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

public class HdfsDataSegmentPuller
implements DataSegmentPuller,
URIDataPuller {
    public static final int DEFAULT_RETRY_COUNT = 3;
    private static final Logger log = new Logger(HdfsDataSegmentPuller.class);
    protected final Configuration config;

    public static FileObject buildFileObject(URI uri, Configuration config) {
        return HdfsDataSegmentPuller.buildFileObject(uri, config, false);
    }

    public static FileObject buildFileObject(final URI uri, final Configuration config, final Boolean overwrite) {
        return new FileObject(){
            final Path path;
            {
                this.path = new Path(uri);
            }

            @Override
            public URI toUri() {
                return uri;
            }

            @Override
            public String getName() {
                return this.path.getName();
            }

            @Override
            public InputStream openInputStream() throws IOException {
                FileSystem fs = this.path.getFileSystem(config);
                return fs.open(this.path);
            }

            @Override
            public OutputStream openOutputStream() throws IOException {
                FileSystem fs = this.path.getFileSystem(config);
                return fs.create(this.path, overwrite.booleanValue());
            }

            @Override
            public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
                throw new UOE("HDFS Reader not supported", new Object[0]);
            }

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                throw new UOE("HDFS CharSequence not supported", new Object[0]);
            }

            @Override
            public Writer openWriter() throws IOException {
                throw new UOE("HDFS Writer not supported", new Object[0]);
            }

            @Override
            public long getLastModified() {
                try {
                    FileSystem fs = this.path.getFileSystem(config);
                    return fs.getFileStatus(this.path).getModificationTime();
                }
                catch (IOException ex) {
                    throw new HdfsIOException(ex);
                }
            }

            @Override
            public boolean delete() {
                try {
                    FileSystem fs = this.path.getFileSystem(config);
                    return fs.delete(this.path, false);
                }
                catch (IOException ex) {
                    throw new HdfsIOException(ex);
                }
            }
        };
    }

    @Inject
    public HdfsDataSegmentPuller(Configuration config) {
        this.config = config;
    }

    public void getSegmentFiles(DataSegment segment, File dir) throws SegmentLoadingException {
        this.getSegmentFiles(this.getPath(segment), dir);
    }

    public FileUtils.FileCopyResult getSegmentFiles(final Path path, final File outDir) throws SegmentLoadingException {
        try {
            final FileSystem fs = path.getFileSystem(this.config);
            if (fs.isDirectory(path)) {
                try {
                    return (FileUtils.FileCopyResult)RetryUtils.retry((Callable)new Callable<FileUtils.FileCopyResult>(){

                        @Override
                        public FileUtils.FileCopyResult call() throws Exception {
                            if (!fs.exists(path)) {
                                throw new SegmentLoadingException("No files found at [%s]", new Object[]{path.toString()});
                            }
                            RemoteIterator children = fs.listFiles(path, false);
                            FileUtils.FileCopyResult result = new FileUtils.FileCopyResult(new File[0]);
                            while (children.hasNext()) {
                                LocatedFileStatus child = (LocatedFileStatus)children.next();
                                Path childPath = child.getPath();
                                String fname = childPath.getName();
                                if (fs.isDirectory(childPath)) {
                                    log.warn("[%s] is a child directory, skipping", new Object[]{childPath.toString()});
                                    continue;
                                }
                                File outFile = new File(outDir, fname);
                                fs.copyToLocalFile(childPath, new Path(outFile.toURI()));
                                result.addFile(outFile);
                            }
                            log.info("Copied %d bytes from [%s] to [%s]", new Object[]{result.size(), path.toString(), outDir.getAbsolutePath()});
                            return result;
                        }
                    }, this.shouldRetryPredicate(), (int)3);
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            if (CompressionUtils.isZip((String)path.getName())) {
                FileUtils.FileCopyResult result = CompressionUtils.unzip((ByteSource)new ByteSource(){

                    public InputStream openStream() throws IOException {
                        return HdfsDataSegmentPuller.this.getInputStream(path);
                    }
                }, (File)outDir, this.shouldRetryPredicate(), (boolean)false);
                log.info("Unzipped %d bytes from [%s] to [%s]", new Object[]{result.size(), path.toString(), outDir.getAbsolutePath()});
                return result;
            }
            if (CompressionUtils.isGz((String)path.getName())) {
                String fname = path.getName();
                File outFile = new File(outDir, CompressionUtils.getGzBaseName((String)fname));
                FileUtils.FileCopyResult result = CompressionUtils.gunzip((ByteSource)new ByteSource(){

                    public InputStream openStream() throws IOException {
                        return HdfsDataSegmentPuller.this.getInputStream(path);
                    }
                }, (File)outFile);
                log.info("Gunzipped %d bytes from [%s] to [%s]", new Object[]{result.size(), path.toString(), outFile.getAbsolutePath()});
                return result;
            }
            throw new SegmentLoadingException("Do not know how to handle file type at [%s]", new Object[]{path.toString()});
        }
        catch (IOException e) {
            throw new SegmentLoadingException((Throwable)e, "Error loading [%s]", new Object[]{path.toString()});
        }
    }

    public FileUtils.FileCopyResult getSegmentFiles(URI uri, File outDir) throws SegmentLoadingException {
        if (!uri.getScheme().equalsIgnoreCase("hdfs")) {
            throw new SegmentLoadingException("Don't know how to load SCHEME for URI [%s]", new Object[]{uri.toString()});
        }
        return this.getSegmentFiles(new Path(uri), outDir);
    }

    public InputStream getInputStream(Path path) throws IOException {
        return HdfsDataSegmentPuller.buildFileObject(path.toUri(), this.config).openInputStream();
    }

    public InputStream getInputStream(URI uri) throws IOException {
        if (!uri.getScheme().equalsIgnoreCase("hdfs")) {
            throw new IAE("Don't know how to load SCHEME [%s] for URI [%s]", new Object[]{uri.getScheme(), uri.toString()});
        }
        return HdfsDataSegmentPuller.buildFileObject(uri, this.config).openInputStream();
    }

    public String getVersion(URI uri) throws IOException {
        try {
            return StringUtils.format((String)"%d", (Object[])new Object[]{HdfsDataSegmentPuller.buildFileObject(uri, this.config).getLastModified()});
        }
        catch (HdfsIOException ex) {
            throw ex.getIOException();
        }
    }

    public Predicate<Throwable> shouldRetryPredicate() {
        return new Predicate<Throwable>(){

            public boolean apply(Throwable input) {
                if (input == null) {
                    return false;
                }
                if (input instanceof HdfsIOException) {
                    return true;
                }
                if (input instanceof IOException) {
                    return true;
                }
                return this.apply(input.getCause());
            }
        };
    }

    private Path getPath(DataSegment segment) {
        return new Path(String.valueOf(segment.getLoadSpec().get("path")));
    }

    public static class HdfsIOException
    extends RuntimeException {
        private final IOException cause;

        public HdfsIOException(IOException ex) {
            super(ex);
            this.cause = ex;
        }

        protected IOException getIOException() {
            return this.cause;
        }
    }
}

